/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;
import pers.XiaoShadiao.NMSLException;

public class PlayerApplet
extends Applet
implements Runnable {
    public static final String AUDIO_PARAMETER = "audioURL";
    private Thread playerThread = null;
    private String fileName = null;
    private Player player = null;
    private static final NMSLException \u8981\u662f\u4ed6\u4e0d\u8bf4 = new NMSLException("\ua676\u26dc\u4dcd\u4df7\u4df2\u4df5\u27b5\u4dcc\u4dcb\u4ded\u4633\u262d\u272a\ua654\u4dff\u4d64\u4de9\u4dfd\u277f\u4dcc\u268d\u2706\u27bb\u4df8\u274c\u27a4\u26c6\u3d65\u4dc0\u4de0\u4dea\u42cb\u4df0\ua69f\u4def\u4ded\ua65e\u4de5\u27ad\u4dc7\u267c\u26c4\u4dca\u2600\ua674\ua66b\ua667");

    protected void play(InputStream in, AudioDevice dev) throws JavaLayerException {
        this.stopPlayer();
        if (in != null && dev != null) {
            this.player = new Player(in, dev);
            this.playerThread = this.createPlayerThread();
            this.playerThread.start();
        }
    }

    protected InputStream getAudioStream() {
        InputStream in = null;
        try {
            URL url = this.getAudioURL();
            if (url != null) {
                in = url.openStream();
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return in;
    }

    protected String getAudioFileName() {
        String urlString = this.fileName;
        if (urlString == null) {
            urlString = this.getParameter(AUDIO_PARAMETER);
        }
        return urlString;
    }

    protected void stopPlayer() throws JavaLayerException {
        if (this.player != null) {
            this.player.close();
            this.player = null;
            this.playerThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        String name = this.getAudioFileName();
        try {
            InputStream in = this.getAudioStream();
            AudioDevice dev = this.getAudioDevice();
            this.play(in, dev);
        }
        catch (JavaLayerException ex) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("Unable to play " + name);
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void run() {
        if (this.player != null) {
            try {
                this.player.play();
            }
            catch (JavaLayerException ex) {
                System.err.println("Problem playing audio: " + ex);
            }
        }
    }

    @Override
    public void init() {
    }

    protected Thread createPlayerThread() {
        return new Thread((Runnable)this, "Audio player thread");
    }

    protected AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    @Override
    public void stop() {
        try {
            this.stopPlayer();
        }
        catch (JavaLayerException ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void destroy() {
    }

    protected URL getAudioURL() {
        String urlString = this.getAudioFileName();
        URL url = null;
        if (urlString != null) {
            try {
                url = new URL(this.getDocumentBase(), urlString);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        return url;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }
}

