/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;
import pers.XiaoShadiao.NMSLException;

public class jlp {
    private boolean remote = false;
    private String fFilename = null;
    private static final NMSLException \u6342\u8033\u6735 = new NMSLException("\u26c7\u4dda\u26a0\u2762\u3f93\u4dc0\u2731\u48f9\u4df9\u27a2\u4dcf\u264c\u4dc5\u4dd5\u4de4\u2662\u4dca\u26db\ua650\u4dd1\u2774\u4dd6\u4dcd\u2668\ua685\u279f\u4dca\u4dd9\u4dfb\ua674\u4c41\u35f0\u4dec\u4de8\u4df7\u497b\ua687\u4dc3\u4de4\u3659\ua698\u3a1c");

    public static jlp createInstance(String[] args) {
        jlp player = new jlp();
        if (!player.parseArgs(args)) {
            player = null;
        }
        return player;
    }

    protected boolean parseArgs(String[] args) {
        boolean parsed = false;
        if (args.length == 1) {
            this.init(args[0]);
            parsed = true;
            this.remote = false;
        } else if (args.length == 2) {
            if (!args[0].equals("-url")) {
                this.showUsage();
            } else {
                this.init(args[1]);
                parsed = true;
                this.remote = true;
            }
        } else {
            this.showUsage();
        }
        return parsed;
    }

    protected void init(String filename) {
        this.fFilename = filename;
    }

    protected InputStream getInputStream() throws IOException {
        FileInputStream fin = new FileInputStream(this.fFilename);
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected InputStream getURLInputStream() throws Exception {
        URL url = new URL(this.fFilename);
        InputStream fin = url.openStream();
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    public jlp(String filename) {
        this.init(filename);
    }

    public void showUsage() {
        System.out.println("Usage: jlp [-url] <filename>");
        System.out.println("");
        System.out.println(" e.g. : java javazoom.jl.player.jlp localfile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.server.com/remotefile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.shoutcastserver.com:8000");
    }

    private jlp() {
    }

    public static void main(String[] args) {
        int retval = 0;
        try {
            jlp player = jlp.createInstance(args);
            if (player != null) {
                player.play();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace(System.err);
            retval = 1;
        }
        System.exit(retval);
    }

    public void play() throws JavaLayerException {
        try {
            System.out.println("playing " + this.fFilename + "...");
            InputStream in = null;
            in = this.remote ? this.getURLInputStream() : this.getInputStream();
            AudioDevice dev = this.getAudioDevice();
            Player player = new Player(in, dev);
            player.play();
        }
        catch (IOException ex) {
            throw new JavaLayerException("Problem playing file " + this.fFilename, ex);
        }
        catch (Exception ex) {
            throw new JavaLayerException("Problem playing file " + this.fFilename, ex);
        }
    }
}

