/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.XiaoShadiao.NMSLException;

public abstract class AbstractWebSocket
extends WebSocketAdapter {
    private boolean tcpNoDelay;
    private long connectionLostTimeout;
    private boolean daemon = false;
    private ScheduledExecutorService connectionLostCheckerService;
    private final Object syncConnectionLost;
    private boolean websocketRunning = false;
    private final Logger log = LoggerFactory.getLogger(AbstractWebSocket.class);
    private ScheduledFuture<?> connectionLostCheckerFuture;
    private boolean reuseAddr;
    private static final NMSLException \u5c0f\u654c = new NMSLException("\u357e\u4df1\ua67f\u4dee\u4dce\u4de3\u26e7\u39ae\ua65f\u4dd3\u4ded\u4dc9\u4ce4\u4de9\u4dd0\ua64f\u4dcc\u4de7\u2780\u4de1\u4df2\u4df2\u4dc5\u26f6\u26dc\u2720\ua650\u35a1\u4dfa\u4dd3\u273c\u4de0\u4de5\u27b7\u3c0d\u4dc6\u2682\u4dd6\u4dd1\u4df2\u4de0\u4dea\u34db\u4dcd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionLostTimeout() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            return (int)TimeUnit.NANOSECONDS.toSeconds(this.connectionLostTimeout);
        }
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostTimeout <= 0L) {
                this.log.trace("Connection lost timer deactivated");
                return;
            }
            this.log.trace("Connection lost timer started");
            this.websocketRunning = true;
            this.restartConnectionLostTimer();
        }
    }

    private void restartConnectionLostTimer() {
        this.cancelConnectionLostTimer();
        this.connectionLostCheckerService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("connectionLostChecker", this.daemon));
        Runnable connectionLostChecker = new Runnable(){
            private ArrayList<WebSocket> connections = new ArrayList();
            private static final NMSLException \u4e0d\u662f\u8868\u9762\u4e0a\u90a3\u4e48\u51b7\u6f20\u7684\u4eba = new NMSLException("\u4c58\ua68e\u4dfa\u3f58\u4dd8\u4de3\u27ba\u2713\u2771\ua676\u43d4\u4dfe\u4dee\u4dd7\u4dd8\u4dc5\u4dd8\ua66d\u26f4\u4dc5\u4ddb\u4dd2\u41df\u4df4\ua644\u4991\u4dd7\u4dcd\u4dcd\u4df1\u4de9\u260c\u4193\u3762\u4df1\u4dcb\u4df2\u4dcc\u4de3");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.connections.clear();
                try {
                    long minimumPongTime;
                    this.connections.addAll(AbstractWebSocket.this.getConnections());
                    Iterator<WebSocket> iterator = AbstractWebSocket.this.syncConnectionLost;
                    synchronized (iterator) {
                        minimumPongTime = (long)((double)System.nanoTime() - (double)AbstractWebSocket.this.connectionLostTimeout * 1.5);
                    }
                    for (WebSocket conn : this.connections) {
                        AbstractWebSocket.this.executeConnectionLostDetection(conn, minimumPongTime);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connections.clear();
            }
        };
        this.connectionLostCheckerFuture = this.connectionLostCheckerService.scheduleAtFixedRate(connectionLostChecker, this.connectionLostTimeout, this.connectionLostTimeout, TimeUnit.NANOSECONDS);
    }

    protected abstract Collection<WebSocket> getConnections();

    private void executeConnectionLostDetection(WebSocket webSocket, long minimumPongTime) {
        if (!(webSocket instanceof WebSocketImpl)) {
            return;
        }
        WebSocketImpl webSocketImpl = (WebSocketImpl)webSocket;
        if (webSocketImpl.getLastPong() < minimumPongTime) {
            this.log.trace("Closing connection due to no pong received: {}", (Object)webSocketImpl);
            webSocketImpl.closeConnection(1006, "The connection was closed because the other endpoint did not respond with a pong in time. For more information check: https://github.com/TooTallNate/Java-WebSocket/wiki/Lost-connection-detection");
        } else if (webSocketImpl.isOpen()) {
            webSocketImpl.sendPing();
        } else {
            this.log.trace("Trying to ping a non open connection: {}", (Object)webSocketImpl);
        }
    }

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionLostTimeout(int connectionLostTimeout) {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            this.connectionLostTimeout = TimeUnit.SECONDS.toNanos(connectionLostTimeout);
            if (this.connectionLostTimeout <= 0L) {
                this.log.trace("Connection lost timer stopped");
                this.cancelConnectionLostTimer();
                return;
            }
            if (this.websocketRunning) {
                this.log.trace("Connection lost timer restarted");
                try {
                    ArrayList<WebSocket> connections = new ArrayList<WebSocket>(this.getConnections());
                    for (WebSocket conn : connections) {
                        if (!(conn instanceof WebSocketImpl)) continue;
                        WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                        webSocketImpl.updateLastPong();
                    }
                }
                catch (Exception e) {
                    this.log.error("Exception during connection lost restart", e);
                }
                this.restartConnectionLostTimer();
            }
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostCheckerService != null || this.connectionLostCheckerFuture != null) {
                this.websocketRunning = false;
                this.log.trace("Connection lost timer stopped");
                this.cancelConnectionLostTimer();
            }
        }
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    private void cancelConnectionLostTimer() {
        if (this.connectionLostCheckerService != null) {
            this.connectionLostCheckerService.shutdownNow();
            this.connectionLostCheckerService = null;
        }
        if (this.connectionLostCheckerFuture != null) {
            this.connectionLostCheckerFuture.cancel(false);
            this.connectionLostCheckerFuture = null;
        }
    }

    public AbstractWebSocket() {
        this.connectionLostTimeout = TimeUnit.SECONDS.toNanos(60L);
        this.syncConnectionLost = new Object();
    }
}

