/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.AbstractWebSocket;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketListener;
import org.java_websocket.client.DnsResolver;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.enums.Opcode;
import org.java_websocket.enums.ReadyState;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.HandshakeImpl1Client;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public abstract class WebSocketClient
extends AbstractWebSocket
implements Runnable,
WebSocket {
    protected URI uri = null;
    private Thread connectReadThread;
    private WebSocketImpl engine = null;
    private SocketFactory socketFactory = null;
    private CountDownLatch closeLatch;
    private Thread writeThread;
    private int connectTimeout = 0;
    private DnsResolver dnsResolver = null;
    private Socket socket = null;
    private OutputStream ostream;
    private CountDownLatch connectLatch;
    private Draft draft;
    private Map<String, String> headers;
    private Proxy proxy = Proxy.NO_PROXY;
    private static final NMSLException \u7f07\u5b9d\u8001\u5e08\u5f88\u5389\u5bb3\u7684 = new NMSLException("\u4df3\u4dcd\u4def\u4dc7\u4dd9\ua690\ua679\u4dd2\u2754\u4dc1\u2714\u4de9\u4dd6\u4dd5\ua67c\u26e1\u4dc7\u4de1\u4dd6\u4dd3\u260e\u2735\u2608\u447c\u4dd2\u2793\u4df7\u4dfe\u4dd1\u4df5\u4991\u276d\u26fd\u493f\u271f\u4dfd\u4de3\u276b\u4ddf\u4dfd\u4de5");

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket conn) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }
        return null;
    }

    private boolean prepareSocket() throws IOException {
        boolean upgradeSocketToSSLSocket = false;
        if (this.proxy != Proxy.NO_PROXY) {
            this.socket = new Socket(this.proxy);
            upgradeSocketToSSLSocket = true;
        } else if (this.socketFactory != null) {
            this.socket = this.socketFactory.createSocket();
        } else if (this.socket == null) {
            this.socket = new Socket(this.proxy);
            upgradeSocketToSSLSocket = true;
        } else if (this.socket.isClosed()) {
            throw new IOException();
        }
        return upgradeSocketToSSLSocket;
    }

    @Override
    public void onWebsocketClosing(WebSocket conn, int code, String reason, boolean remote) {
        this.onClosing(code, reason, remote);
    }

    @Override
    public SSLSession getSSLSession() {
        if (!this.hasSSLSupport()) {
            throw new IllegalArgumentException("This websocket uses ws instead of wss. No SSLSession available.");
        }
        return ((SSLSocket)this.socket).getSession();
    }

    @Override
    public boolean hasBufferedData() {
        return this.engine.hasBufferedData();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.engine.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.engine.getRemoteSocketAddress();
    }

    @Override
    public <T> void setAttachment(T attachment) {
        this.engine.setAttachment(attachment);
    }

    @Override
    public boolean isClosed() {
        return this.engine.isClosed();
    }

    public void onCloseInitiated(int code, String reason) {
    }

    protected void onSetSSLParameters(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
    }

    public URI getURI() {
        return this.uri;
    }

    private void upgradeSocketToSSL() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLSocketFactory factory = this.socketFactory instanceof SSLSocketFactory ? (SSLSocketFactory)this.socketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.socket = factory.createSocket(this.socket, this.uri.getHost(), this.getPort(), true);
    }

    private int getPort() {
        int port = this.uri.getPort();
        String scheme = this.uri.getScheme();
        if ("wss".equals(scheme)) {
            return port == -1 ? 443 : port;
        }
        if ("ws".equals(scheme)) {
            return port == -1 ? 80 : port;
        }
        throw new IllegalArgumentException("unknown scheme: " + scheme);
    }

    @Override
    public void close(int code, String message) {
        this.engine.close(code, message);
    }

    @Override
    public void send(byte[] data) {
        this.engine.send(data);
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.engine.sendFrame(framedata);
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket conn, int code, String reason) {
        this.onCloseInitiated(code, reason);
    }

    @Override
    public final void onWriteDemand(WebSocket conn) {
    }

    @Override
    public void send(String text) {
        this.engine.send(text);
    }

    public void setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        this.proxy = proxy;
    }

    @Override
    public void send(ByteBuffer bytes) {
        this.engine.send(bytes);
    }

    @Override
    public void sendFrame(Collection<Framedata> frames) {
        this.engine.sendFrame(frames);
    }

    @Override
    public IProtocol getProtocol() {
        return this.engine.getProtocol();
    }

    public abstract void onMessage(String var1);

    @Override
    public <T> T getAttachment() {
        return this.engine.getAttachment();
    }

    public void connect() {
        if (this.connectReadThread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.connectReadThread = new Thread(this);
        this.connectReadThread.setDaemon(this.isDaemon());
        this.connectReadThread.setName("WebSocketConnectReadThread-" + this.connectReadThread.getId());
        this.connectReadThread.start();
    }

    @Override
    public void closeConnection(int code, String message) {
        this.engine.closeConnection(code, message);
    }

    public void onMessage(ByteBuffer bytes) {
    }

    public void clearHeaders() {
        this.headers = null;
    }

    public WebSocketClient(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders, int connectTimeout) {
        this.connectLatch = new CountDownLatch(1);
        this.closeLatch = new CountDownLatch(1);
        if (serverUri == null) {
            throw new IllegalArgumentException();
        }
        if (protocolDraft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = serverUri;
        this.draft = protocolDraft;
        this.dnsResolver = new DnsResolver(){
            private static final NMSLException \u5927\u6d77\u53d8\u6210\u96e8\u6ef4 = new NMSLException("\u3d7d\u4dce\u4de7\u39e3\u2794\u3c3d\u2729\u4dd0\u274e\u4dcf\u26d8\u4de1\ua67e\ua69e\u4dc1\u4ddc\u2711\u263f\u4dcb\u4dff\ua64f\u4ddd\u2697\u4dc3\u4de4\u2741\u4de5\u271b\u4de5\ua679\u4dde\u4dc6\u2715\u4dd8\u26f9\u4dc0\u270e\u4dca\u3e5c\u4de2\u275b\u4dcf\u27b0\u2720\u4df9\u4dc5\ua693\u2748");

            @Override
            public InetAddress resolve(URI uri) throws UnknownHostException {
                return InetAddress.getByName(uri.getHost());
            }
        };
        if (httpHeaders != null) {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(httpHeaders);
        }
        this.connectTimeout = connectTimeout;
        this.setTcpNoDelay(false);
        this.setReuseAddr(false);
        this.engine = new WebSocketImpl((WebSocketListener)this, protocolDraft);
    }

    @Override
    public final void onWebsocketClose(WebSocket conn, int code, String reason, boolean remote) {
        this.stopConnectionLostTimer();
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
        this.onClose(code, reason, remote);
        this.connectLatch.countDown();
        this.closeLatch.countDown();
    }

    public boolean connectBlocking(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.connect();
        return this.connectLatch.await(timeout, timeUnit) && this.engine.isOpen();
    }

    @Override
    public ReadyState getReadyState() {
        return this.engine.getReadyState();
    }

    public WebSocketClient(URI serverUri, Draft protocolDraft) {
        this(serverUri, protocolDraft, null, 0);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, String message) {
        this.onMessage(message);
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket conn) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.engine.isOpen();
    }

    public String removeHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.remove(key);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        this.onMessage(blob);
    }

    public boolean reconnectBlocking() throws InterruptedException {
        this.reset();
        return this.connectBlocking();
    }

    @Override
    public void run() {
        InputStream istream;
        try {
            boolean upgradeSocketToSSLSocket = this.prepareSocket();
            this.socket.setTcpNoDelay(this.isTcpNoDelay());
            this.socket.setReuseAddress(this.isReuseAddr());
            if (!this.socket.isConnected()) {
                InetSocketAddress addr = this.dnsResolver == null ? InetSocketAddress.createUnresolved(this.uri.getHost(), this.getPort()) : new InetSocketAddress(this.dnsResolver.resolve(this.uri), this.getPort());
                this.socket.connect(addr, this.connectTimeout);
            }
            if (upgradeSocketToSSLSocket && "wss".equals(this.uri.getScheme())) {
                this.upgradeSocketToSSL();
            }
            if (this.socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)this.socket;
                SSLParameters sslParameters = sslSocket.getSSLParameters();
                this.onSetSSLParameters(sslParameters);
                sslSocket.setSSLParameters(sslParameters);
            }
            istream = this.socket.getInputStream();
            this.ostream = this.socket.getOutputStream();
            this.sendHandshake();
        }
        catch (Exception e) {
            this.onWebsocketError(this.engine, e);
            this.engine.closeConnection(-1, e.getMessage());
            return;
        }
        catch (InternalError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof IOException) {
                IOException cause = (IOException)e.getCause().getCause();
                this.onWebsocketError(this.engine, cause);
                this.engine.closeConnection(-1, cause.getMessage());
                return;
            }
            throw e;
        }
        if (this.writeThread != null) {
            this.writeThread.interrupt();
            try {
                this.writeThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.writeThread = new Thread(new WebsocketWriteThread(this));
        this.writeThread.setDaemon(this.isDaemon());
        this.writeThread.start();
        byte[] rawbuffer = new byte[16384];
        try {
            int readBytes;
            while (!this.isClosing() && !this.isClosed() && (readBytes = istream.read(rawbuffer)) != -1) {
                this.engine.decode(ByteBuffer.wrap(rawbuffer, 0, readBytes));
            }
            this.engine.eot();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        catch (RuntimeException e) {
            this.onError(e);
            this.engine.closeConnection(1006, e.getMessage());
        }
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public abstract void onError(Exception var1);

    private void handleIOException(IOException e) {
        if (e instanceof SSLException) {
            this.onError(e);
        }
        this.engine.eot();
    }

    @Override
    public void sendFragmentedFrame(Opcode op, ByteBuffer buffer, boolean fin) {
        this.engine.sendFragmentedFrame(op, buffer, fin);
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String part1 = this.uri.getRawPath();
        String part2 = this.uri.getRawQuery();
        String path = part1 == null || part1.length() == 0 ? "/" : part1;
        if (part2 != null) {
            path = path + '?' + part2;
        }
        int port = this.getPort();
        String host = this.uri.getHost() + (port != 80 && port != 443 ? ":" + port : "");
        HandshakeImpl1Client handshake = new HandshakeImpl1Client();
        handshake.setResourceDescriptor(path);
        handshake.put("Host", host);
        if (this.headers != null) {
            for (Map.Entry<String, String> kv : this.headers.entrySet()) {
                handshake.put(kv.getKey(), kv.getValue());
            }
        }
        this.engine.startHandshake(handshake);
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }

    @Override
    public boolean hasSSLSupport() {
        return this.socket instanceof SSLSocket;
    }

    public WebSocketClient(URI serverUri) {
        this(serverUri, new Draft_6455());
    }

    public void closeBlocking() throws InterruptedException {
        this.close();
        this.closeLatch.await();
    }

    @Override
    public void close() {
        if (this.writeThread != null) {
            this.engine.close(1000);
        }
    }

    public WebSocketClient(URI serverUri, Map<String, String> httpHeaders) {
        this(serverUri, new Draft_6455(), httpHeaders);
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.headers.put(key, value);
    }

    public WebSocketClient(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders) {
        this(serverUri, protocolDraft, httpHeaders, 0);
    }

    public abstract void onOpen(ServerHandshake var1);

    @Override
    public void close(int code) {
        this.engine.close(code);
    }

    public void reconnect() {
        this.reset();
        this.connect();
    }

    public void onClosing(int code, String reason, boolean remote) {
    }

    public boolean connectBlocking() throws InterruptedException {
        this.connect();
        this.connectLatch.await();
        return this.engine.isOpen();
    }

    @Override
    public boolean isClosing() {
        return this.engine.isClosing();
    }

    @Override
    public boolean isFlushAndClose() {
        return this.engine.isFlushAndClose();
    }

    @Override
    public void sendPing() {
        this.engine.sendPing();
    }

    @Override
    public final void onWebsocketError(WebSocket conn, Exception ex) {
        this.onError(ex);
    }

    @Deprecated
    public void setSocket(Socket socket) {
        if (this.socket != null) {
            throw new IllegalStateException("socket has already been set");
        }
        this.socket = socket;
    }

    public abstract void onClose(int var1, String var2, boolean var3);

    @Override
    public final void onWebsocketOpen(WebSocket conn, Handshakedata handshake) {
        this.startConnectionLostTimer();
        this.onOpen((ServerHandshake)handshake);
        this.connectLatch.countDown();
    }

    @Override
    protected Collection<WebSocket> getConnections() {
        return Collections.singletonList(this.engine);
    }

    public WebSocket getConnection() {
        return this.engine;
    }

    private void reset() {
        Thread current = Thread.currentThread();
        if (current == this.writeThread || current == this.connectReadThread) {
            throw new IllegalStateException("You cannot initialize a reconnect out of the websocket thread. Use reconnect in another thread to ensure a successful cleanup.");
        }
        try {
            this.closeBlocking();
            if (this.writeThread != null) {
                this.writeThread.interrupt();
                this.writeThread.join();
                this.writeThread = null;
            }
            if (this.connectReadThread != null) {
                this.connectReadThread.interrupt();
                this.connectReadThread.join();
                this.connectReadThread = null;
            }
            this.draft.reset();
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            this.onError(e);
            this.engine.closeConnection(1006, e.getMessage());
            return;
        }
        this.connectLatch = new CountDownLatch(1);
        this.closeLatch = new CountDownLatch(1);
        this.engine = new WebSocketImpl((WebSocketListener)this, this.draft);
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    @Override
    public String getResourceDescriptor() {
        return this.uri.getPath();
    }

    private class WebsocketWriteThread
    implements Runnable {
        private final WebSocketClient webSocketClient;
        private static final NMSLException \u6211\u652f\u6301 = new NMSLException("\u4df2\ua668\u4dcc\u2725\u4de1\u4dc9\ua678\u4df0\ua655\ua673\u4dde\u4dd4\ua66a\u4de9\u4dc7\ua65c\u4df6\u265e\ua67a\u2648\u2633\u4df2\u4dce\u4df0\u2799\u26a4\u4de6\u4dd7\u4dc4\u4dc6\ua65b\ua648\u2725\u4de3\u4de1\u26d3\u4ddb\u2737");

        WebsocketWriteThread(WebSocketClient webSocketClient2) {
            this.webSocketClient = webSocketClient2;
        }

        private void closeSocket() {
            try {
                if (WebSocketClient.this.socket != null) {
                    WebSocketClient.this.socket.close();
                }
            }
            catch (IOException ex) {
                WebSocketClient.this.onWebsocketError(this.webSocketClient, ex);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketWriteThread-" + Thread.currentThread().getId());
            try {
                this.runWriteData();
            }
            catch (IOException e) {
                WebSocketClient.this.handleIOException(e);
            }
            finally {
                this.closeSocket();
            }
        }

        private void runWriteData() throws IOException {
            try {
                while (!Thread.interrupted()) {
                    ByteBuffer buffer = ((WebSocketClient)WebSocketClient.this).engine.outQueue.take();
                    WebSocketClient.this.ostream.write(buffer.array(), 0, buffer.limit());
                    WebSocketClient.this.ostream.flush();
                }
            }
            catch (InterruptedException e) {
                for (ByteBuffer buffer : ((WebSocketClient)WebSocketClient.this).engine.outQueue) {
                    WebSocketClient.this.ostream.write(buffer.array(), 0, buffer.limit());
                    WebSocketClient.this.ostream.flush();
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

