/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import java.nio.ByteBuffer;
import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.ContinuousFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.framing.PongFrame;
import org.java_websocket.framing.TextFrame;
import org.java_websocket.util.ByteBufferUtils;
import pers.XiaoShadiao.NMSLException;

public abstract class FramedataImpl1
implements Framedata {
    private ByteBuffer unmaskedpayload;
    private Opcode optcode;
    private boolean rsv3;
    private boolean fin;
    private boolean transferemasked;
    private boolean rsv1;
    private boolean rsv2;
    private static final NMSLException \u6342\u8033\u6735 = new NMSLException("\ua68f\ua651\u26d8\u4dd5\u4dd4\u4dd4\u4dee\u4dde\u4df6\u4dd9\u2748\u2710\u4df7\u27aa\u2609\u2620\u35cc\u2627\u4deb\u4de3\u4de7\u4ddd\u4def\ua68d\ua676\u274d\ua675\u4561\u270c\ua69c\u4dd4\ua653\u4ddc\u2628\ua660\u279a\ua66a\u4dc8\ua660\u4df9\u4dc7\u3466\u3b41");

    public int hashCode() {
        int result = this.fin ? 1 : 0;
        result = 31 * result + this.optcode.hashCode();
        result = 31 * result + (this.unmaskedpayload != null ? this.unmaskedpayload.hashCode() : 0);
        result = 31 * result + (this.transferemasked ? 1 : 0);
        result = 31 * result + (this.rsv1 ? 1 : 0);
        result = 31 * result + (this.rsv2 ? 1 : 0);
        result = 31 * result + (this.rsv3 ? 1 : 0);
        return result;
    }

    public void setRSV2(boolean rsv2) {
        this.rsv2 = rsv2;
    }

    public void setRSV3(boolean rsv3) {
        this.rsv3 = rsv3;
    }

    @Override
    public boolean isRSV1() {
        return this.rsv1;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    @Override
    public boolean isRSV2() {
        return this.rsv2;
    }

    @Override
    public boolean isFin() {
        return this.fin;
    }

    public void setTransferemasked(boolean transferemasked) {
        this.transferemasked = transferemasked;
    }

    @Override
    public ByteBuffer getPayloadData() {
        return this.unmaskedpayload;
    }

    public abstract void isValid() throws InvalidDataException;

    public static FramedataImpl1 get(Opcode opcode) {
        if (opcode == null) {
            throw new IllegalArgumentException("Supplied opcode cannot be null");
        }
        switch (opcode) {
            case PING: {
                return new PingFrame();
            }
            case PONG: {
                return new PongFrame();
            }
            case TEXT: {
                return new TextFrame();
            }
            case BINARY: {
                return new BinaryFrame();
            }
            case CLOSING: {
                return new CloseFrame();
            }
            case CONTINUOUS: {
                return new ContinuousFrame();
            }
        }
        throw new IllegalArgumentException("Supplied opcode is invalid");
    }

    @Override
    public Opcode getOpcode() {
        return this.optcode;
    }

    public FramedataImpl1(Opcode op) {
        this.optcode = op;
        this.unmaskedpayload = ByteBufferUtils.getEmptyByteBuffer();
        this.fin = true;
        this.transferemasked = false;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
    }

    @Override
    public boolean getTransfereMasked() {
        return this.transferemasked;
    }

    @Override
    public boolean isRSV3() {
        return this.rsv3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FramedataImpl1 that = (FramedataImpl1)o;
        if (this.fin != that.fin) {
            return false;
        }
        if (this.transferemasked != that.transferemasked) {
            return false;
        }
        if (this.rsv1 != that.rsv1) {
            return false;
        }
        if (this.rsv2 != that.rsv2) {
            return false;
        }
        if (this.rsv3 != that.rsv3) {
            return false;
        }
        if (this.optcode != that.optcode) {
            return false;
        }
        return this.unmaskedpayload != null ? this.unmaskedpayload.equals(that.unmaskedpayload) : that.unmaskedpayload == null;
    }

    public String toString() {
        return "Framedata{ opcode:" + (Object)((Object)this.getOpcode()) + ", fin:" + this.isFin() + ", rsv1:" + this.isRSV1() + ", rsv2:" + this.isRSV2() + ", rsv3:" + this.isRSV3() + ", payload length:[pos:" + this.unmaskedpayload.position() + ", len:" + this.unmaskedpayload.remaining() + "], payload:" + (this.unmaskedpayload.remaining() > 1000 ? "(too big to display)" : new String(this.unmaskedpayload.array())) + '}';
    }

    public void setPayload(ByteBuffer payload) {
        this.unmaskedpayload = payload;
    }

    @Override
    public void append(Framedata nextframe) {
        ByteBuffer b = nextframe.getPayloadData();
        if (this.unmaskedpayload == null) {
            this.unmaskedpayload = ByteBuffer.allocate(b.remaining());
            b.mark();
            this.unmaskedpayload.put(b);
            b.reset();
        } else {
            b.mark();
            this.unmaskedpayload.position(this.unmaskedpayload.limit());
            this.unmaskedpayload.limit(this.unmaskedpayload.capacity());
            if (b.remaining() > this.unmaskedpayload.remaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(b.remaining() + this.unmaskedpayload.capacity());
                this.unmaskedpayload.flip();
                tmp.put(this.unmaskedpayload);
                tmp.put(b);
                this.unmaskedpayload = tmp;
            } else {
                this.unmaskedpayload.put(b);
            }
            this.unmaskedpayload.rewind();
            b.reset();
        }
        this.fin = nextframe.isFin();
    }

    public void setRSV1(boolean rsv1) {
        this.rsv1 = rsv1;
    }
}

