/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternComma;
    private static final Pattern patternSpace;
    private final String providedProtocol;
    private static final NMSLException \u5411\u5bbd\u539a\u7684\u5927\u5730\u4f2f\u4f2f\u501f\u98ce;

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    static {
        \u5411\u5bbd\u539a\u7684\u5927\u5730\u4f2f\u4f2f\u501f\u98ce = new NMSLException("\u2668\ua661\ua661\u2738\u4203\u277d\u4dc7\u2674\u4dd6\u2637\u4dd7\u4dd8\u4ddf\u3cac\u4dfd\u4dcf\u4dee\u4df7\ua68a\u4dfa\u2771\u4dc0\u4dfb\u2789\u4ddd\u2636\u4dc9\u4dee\u4dce\u4de5\u3ef0\u2743\ua69d\u4dfb\u26a9\u3c78\u4dde\u4dda\u4dc6\u4de8\u4de7\u4dcd");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

