/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.MessageFormatter;
import pers.XiaoShadiao.NMSLException;

public class NormalizedParameters {
    final String message;
    final Object[] arguments;
    final Throwable throwable;
    private static final NMSLException \u4e58\u7740\u897f\u98ce = new NMSLException("\u4ddf\u2779\u4dd0\u4df2\u4dea\u4df1\ua65a\u4de5\u4819\u44c2\u3d5f\u2742\u4deb\u43d1\u2750\u4dc7\ua692\u4dc0\u4ddb\u3ca2\u3860\ua67d\u4dd3\ua69f\u261f\u4de1\u4987\u4dc5\u2775\u4ddb\ua657\u4dd7\u2745\u4dcc\u4dfa\u3b23\u4def\u4dfb");

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static NormalizedParameters normalize(String msg, Object[] arguments, Throwable t) {
        if (t != null) {
            return new NormalizedParameters(msg, arguments, t);
        }
        if (arguments == null || arguments.length == 0) {
            return new NormalizedParameters(msg, arguments, t);
        }
        Throwable throwableCandidate = NormalizedParameters.getThrowableCandidate(arguments);
        if (throwableCandidate != null) {
            Object[] trimmedArguments = MessageFormatter.trimmedCopy(arguments);
            return new NormalizedParameters(msg, trimmedArguments, throwableCandidate);
        }
        return new NormalizedParameters(msg, arguments);
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMessage() {
        return this.message;
    }

    public NormalizedParameters(String message, Object[] arguments, Throwable throwable) {
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
    }

    public static NormalizedParameters normalize(LoggingEvent event) {
        return NormalizedParameters.normalize(event.getMessage(), event.getArgumentArray(), event.getThrowable());
    }

    public NormalizedParameters(String message, Object[] arguments) {
        this(message, arguments, null);
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            System.arraycopy(argArray, 0, trimmed, 0, trimmedLen);
        }
        return trimmed;
    }
}

