/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;
import pers.XiaoShadiao.NMSLException;

public class SubstituteLoggerFactory
implements ILoggerFactory {
    volatile boolean postInitialization = false;
    final Map<String, SubstituteLogger> loggers = new ConcurrentHashMap<String, SubstituteLogger>();
    final LinkedBlockingQueue<SubstituteLoggingEvent> eventQueue = new LinkedBlockingQueue();
    private static final NMSLException \u628a\u7f07\u5b9d\u7684\u8111\u888b\u90fd\u542c\u5927\u4e86 = new NMSLException("\u2602\u4caa\ua677\u3bbe\u4df4\u4dd8\u4ddc\u4dc5\u26eb\u4dc3\u4df3\u4def\u4dcd\u4dd7\ua699\u400e\u420d\u26fd\u4dcd\ua640\u4df4\u27a9\ua672\u4df7\u2734\u2743\u27bf\u4df4\u4df3\u26b0\u3e6d\u4dc8\u4dc0\u4def\u4dce\u4a58\u3428\u4dd4\u4808\u4df2\ua641\u4243\u4df3");

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public List<SubstituteLogger> getLoggers() {
        return new ArrayList<SubstituteLogger>(this.loggers.values());
    }

    public void clear() {
        this.loggers.clear();
        this.eventQueue.clear();
    }

    public void postInitialization() {
        this.postInitialization = true;
    }

    public LinkedBlockingQueue<SubstituteLoggingEvent> getEventQueue() {
        return this.eventQueue;
    }

    @Override
    public synchronized Logger getLogger(String name) {
        SubstituteLogger logger = this.loggers.get(name);
        if (logger == null) {
            logger = new SubstituteLogger(name, this.eventQueue, this.postInitialization);
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

