/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static final NMSLException \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684;

    static {
        \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684 = new NMSLException("\u4dcd\u4df6\u4dc3\u4dde\u4dee\u4dc9\ua65c\u4194\ua68c\u4dd4\u4dc6\u26fd\u27a8\u4237\ua66b\u4dc3\u4ddb\u4dc2\u4de8\u4dd8\ua665\u46af\u278f\u4dcf\u4dfe\u4c22\u4dc3\u4ceb\u38dd\u4dd8\u4dd8\u4dea\u2798\u4dfa\u264d\u4dfb\u4de4\u4de8\u4df9\u3b9b\u4dc9\u4c87\u275b\u4213\u4dce\u4de9\u4dca");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    private Util() {
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private static final NMSLException \u4f59\u4e0b\u7684 = new NMSLException("\u4ddd\u4deb\ua663\u4dd6\u4dcf\u273d\u4ddf\u4deb\ua689\u263e\u4dcd\ua687\u4dc6\u27bf\u4ddc\u2755\u3ede\ua69c\u4de9\u268c\u4413\u4dce\ua67a\u487d\u2740\u4dd5\ua669\u4de2\ua640\u4dd4\u266a\u4de3\u27a9\ua640\u4ddb\u4df0\u4de7\u4dfe\u4dd4\u269f\u4dd6\ua684\u4de6\u4df2");

        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

