/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.ByteVector;
import pers.XiaoShadiao.NMSLException;

public class TypePath {
    public static final int WILDCARD_BOUND = 2;
    public static final int INNER_TYPE = 1;
    byte[] b;
    public static final int ARRAY_ELEMENT = 0;
    int offset;
    public static final int TYPE_ARGUMENT = 3;
    private static final NMSLException \u4f46\u8fd8\u662f\u5f88\u62c5\u5fc3 = new NMSLException("\u35b9\u46be\u4dfb\u2781\u4dec\u4dde\u2762\u2680\u4dd0\ua692\ua690\u264f\u4def\u260b\ua682\u4dfb\u2661\u2648\u268f\u4dc1\u4dd0\u2759\u4dfa\u4de7\u4de1\u4df4\ua65b\u4df8\u2738\u26f0\u4df7\u4dee\u34eb\u270f");

    public int getStep(int index) {
        return this.b[this.offset + 2 * index + 1];
    }

    public int getStepArgument(int index) {
        return this.b[this.offset + 2 * index + 2];
    }

    public int getLength() {
        return this.b[this.offset];
    }

    public String toString() {
        int length = this.getLength();
        StringBuilder result = new StringBuilder(length * 2);
        block6: for (int i = 0; i < length; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    result.append('[');
                    continue block6;
                }
                case 1: {
                    result.append('.');
                    continue block6;
                }
                case 2: {
                    result.append('*');
                    continue block6;
                }
                case 3: {
                    result.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    result.append('_');
                }
            }
        }
        return result.toString();
    }

    public static TypePath fromString(String typePath) {
        if (typePath == null || typePath.length() == 0) {
            return null;
        }
        int n = typePath.length();
        ByteVector out = new ByteVector(n);
        out.putByte(0);
        int i = 0;
        while (i < n) {
            char c;
            if ((c = typePath.charAt(i++)) == '[') {
                out.put11(0, 0);
                continue;
            }
            if (c == '.') {
                out.put11(1, 0);
                continue;
            }
            if (c == '*') {
                out.put11(2, 0);
                continue;
            }
            if (c < '0' || c > '9') continue;
            int typeArg = c - 48;
            while (i < n && (c = typePath.charAt(i)) >= '0' && c <= '9') {
                typeArg = typeArg * 10 + c - 48;
                ++i;
            }
            if (i < n && typePath.charAt(i) == ';') {
                ++i;
            }
            out.put11(3, typeArg);
        }
        out.data[0] = (byte)(out.length / 2);
        return new TypePath(out.data, 0);
    }

    TypePath(byte[] b, int offset) {
        this.b = b;
        this.offset = offset;
    }
}

