/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.commons;

import java.util.Stack;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureRemapper
extends SignatureVisitor {
    private Stack<String> classNames = new Stack();
    private final SignatureVisitor v;
    private final Remapper remapper;
    private static final NMSLException \u4e0d\u6b62\u6709\u81ea\u5df1\u7684\u613f\u671b = new NMSLException("\u4deb\ua66b\u4dd8\u4dfb\u4dcc\u4dec\u4dfa\u27b6\u4dda\u4dde\u4dd8\u4ded\u4df3\u4dc1\u3a9f\u4dd7\u26ec\u4dfd\u4dea\u2705\u4dd1\u4dcd\u27a9\u4def\u4dd5\ua66b\u2772\ua672\u2648\u4dd9\u26ea\u2731");

    public void visitBaseType(char descriptor) {
        this.v.visitBaseType(descriptor);
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.v.visitTypeArgument(wildcard);
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    public void visitFormalTypeParameter(String name) {
        this.v.visitFormalTypeParameter(name);
    }

    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    public void visitTypeVariable(String name) {
        this.v.visitTypeVariable(name);
    }

    protected SignatureRemapper(int api, SignatureVisitor v, Remapper remapper) {
        super(api);
        this.v = v;
        this.remapper = remapper;
    }

    public void visitEnd() {
        this.v.visitEnd();
        this.classNames.pop();
    }

    public void visitClassType(String name) {
        this.classNames.push(name);
        this.v.visitClassType(this.remapper.mapType(name));
    }

    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    public void visitInnerClassType(String name) {
        String outerClassName = this.classNames.pop();
        String className = outerClassName + '$' + name;
        this.classNames.push(className);
        String remappedOuter = this.remapper.mapType(outerClassName) + '$';
        String remappedName = this.remapper.mapType(className);
        int index = remappedName.startsWith(remappedOuter) ? remappedOuter.length() : remappedName.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(remappedName.substring(index));
    }

    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    public SignatureRemapper(SignatureVisitor v, Remapper remapper) {
        this(327680, v, remapper);
    }

    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }
}

