/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureReader {
    private final String signature;
    private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b9d = new NMSLException("\u4de6\u4def\u4dff\u38d7\u4dee\u4dfc\u4de3\u2752\u4dd4\u268a\ua674\ua662\u2760\u4dd7\u4dfe\u268e\u26ea\u4de9\ua65e\u2688\u4dea\u4dd7\u269b\u2662\u4def\ua67c\ua645\ua656\u4dea\u4dee\ua689\u4df7\u400f\u274e\u4dea\ua67c\u3b06\u3ea7\u4dff\u27bd\u264e\u4dc3\u2793\u2793\ua643\u273f\u4de3");

    public void acceptType(SignatureVisitor v) {
        SignatureReader.parseType(this.signature, 0, v);
    }

    private static int parseType(String signature, int pos, SignatureVisitor v) {
        char c = signature.charAt(pos++);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                v.visitBaseType(c);
                return pos;
            }
            case '[': {
                return SignatureReader.parseType(signature, pos, v.visitArrayType());
            }
            case 'T': {
                int end = signature.indexOf(59, pos);
                v.visitTypeVariable(signature.substring(pos, end));
                return end + 1;
            }
        }
        int start = pos;
        boolean visited = false;
        boolean inner = false;
        while (true) {
            c = signature.charAt(pos++);
            block5 : switch (c) {
                case '.': 
                case ';': {
                    String name;
                    if (!visited) {
                        name = signature.substring(start, pos - 1);
                        if (inner) {
                            v.visitInnerClassType(name);
                        } else {
                            v.visitClassType(name);
                        }
                    }
                    if (c == ';') {
                        v.visitEnd();
                        return pos;
                    }
                    start = pos;
                    visited = false;
                    inner = true;
                    break;
                }
                case '<': {
                    String name = signature.substring(start, pos - 1);
                    if (inner) {
                        v.visitInnerClassType(name);
                    } else {
                        v.visitClassType(name);
                    }
                    visited = true;
                    block15: while (true) {
                        c = signature.charAt(pos);
                        switch (c) {
                            case '>': {
                                break block5;
                            }
                            case '*': {
                                ++pos;
                                v.visitTypeArgument();
                                continue block15;
                            }
                            case '+': 
                            case '-': {
                                pos = SignatureReader.parseType(signature, pos + 1, v.visitTypeArgument(c));
                                continue block15;
                            }
                        }
                        pos = SignatureReader.parseType(signature, pos, v.visitTypeArgument('='));
                    }
                }
            }
        }
    }

    public SignatureReader(String signature) {
        this.signature = signature;
    }

    public void accept(SignatureVisitor v) {
        int pos;
        String signature = this.signature;
        int len = signature.length();
        if (signature.charAt(0) == '<') {
            char c;
            pos = 2;
            do {
                int end = signature.indexOf(58, pos);
                v.visitFormalTypeParameter(signature.substring(pos - 1, end));
                pos = end + 1;
                c = signature.charAt(pos);
                if (c == 'L' || c == '[' || c == 'T') {
                    pos = SignatureReader.parseType(signature, pos, v.visitClassBound());
                }
                while ((c = signature.charAt(pos++)) == ':') {
                    pos = SignatureReader.parseType(signature, pos, v.visitInterfaceBound());
                }
            } while (c != '>');
        } else {
            pos = 0;
        }
        if (signature.charAt(pos) == '(') {
            ++pos;
            while (signature.charAt(pos) != ')') {
                pos = SignatureReader.parseType(signature, pos, v.visitParameterType());
            }
            pos = SignatureReader.parseType(signature, pos + 1, v.visitReturnType());
            while (pos < len) {
                pos = SignatureReader.parseType(signature, pos + 1, v.visitExceptionType());
            }
        } else {
            pos = SignatureReader.parseType(signature, pos, v.visitSuperclass());
            while (pos < len) {
                pos = SignatureReader.parseType(signature, pos, v.visitInterface());
            }
        }
    }
}

