/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureWriter
extends SignatureVisitor {
    private int argumentStack;
    private final StringBuilder buf = new StringBuilder();
    private boolean hasParameters;
    private boolean hasFormals;
    private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b89 = new NMSLException("\u4ddf\u35a6\u4ddb\u4de9\u2676\u27b1\u2687\u4dd4\u4ddb\u46ac\ua653\u4df4\u4df9\u4ddf\u4deb\ua65a\u4dfd\u269e\u27a8\u276c\u4dc5\u4dd7\u4ded\u2780\u4dd8\ua640\u4dd7\ua655\u26f5\ua664\u4dcd");

    private void endArguments() {
        if (this.argumentStack % 2 != 0) {
            this.buf.append('>');
        }
        this.argumentStack /= 2;
    }

    public void visitFormalTypeParameter(String name) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.buf.append('<');
        }
        this.buf.append(name);
        this.buf.append(':');
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public void visitBaseType(char descriptor) {
        this.buf.append(descriptor);
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureWriter() {
        super(327680);
    }

    public String toString() {
        return this.buf.toString();
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append('^');
        return this;
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.buf.append('>');
        }
    }

    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        this.buf.append('*');
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append(':');
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append(';');
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        if (wildcard != '=') {
            this.buf.append(wildcard);
        }
        return this;
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append('[');
        return this;
    }

    public void visitTypeVariable(String name) {
        this.buf.append('T');
        this.buf.append(name);
        this.buf.append(';');
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append('(');
        }
        this.buf.append(')');
        return this;
    }

    public void visitInnerClassType(String name) {
        this.endArguments();
        this.buf.append('.');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public void visitClassType(String name) {
        this.buf.append('L');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.buf.append('(');
        }
        return this;
    }
}

