/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import pers.XiaoShadiao.NMSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public List<Object> values;
    public String desc;
    private static final NMSLException \u4f60\u62cd\u5341 = new NMSLException("\u274f\u4dff\u263e\u279f\u278b\u271d\u265f\u26a9\u3f9c\u271f\u4482\u4de0\u41b4\u345f\u4de4\u4dea\u4dfd\u4dec\u26fb\u3a95\u2728\u4495\u4ddc\ua675\u4dd1\u260f\ua694\u264b\u4dca\u4de6\u4dc1\u443b\u271e\u4dd1\u4ded\u4dc0\u38f5\u4938\ua642\u4df2\u4de7\u4dfc\ua649\u4dc8\u27a4\u2782\u270e\u2645\u417b");

    public void check(int api) {
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    @Override
    public void visit(String name, Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            ArrayList<Byte> l = new ArrayList<Byte>(v.length);
            for (byte b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v.length);
            for (boolean b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof short[]) {
            short[] v = (short[])value;
            ArrayList<Short> l = new ArrayList<Short>(v.length);
            for (short s : v) {
                l.add(s);
            }
            this.values.add(l);
        } else if (value instanceof char[]) {
            char[] v = (char[])value;
            ArrayList<Character> l = new ArrayList<Character>(v.length);
            for (char c : v) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            ArrayList<Integer> l = new ArrayList<Integer>(v.length);
            for (int i : v) {
                l.add(i);
            }
            this.values.add(l);
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            ArrayList<Long> l = new ArrayList<Long>(v.length);
            for (long lng : v) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            ArrayList<Float> l = new ArrayList<Float>(v.length);
            for (float f : v) {
                l.add(Float.valueOf(f));
            }
            this.values.add(l);
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            ArrayList<Double> l = new ArrayList<Double>(v.length);
            for (double d : v) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        AnnotationNode annotation = new AnnotationNode(desc);
        this.values.add(annotation);
        return annotation;
    }

    AnnotationNode(List<Object> values) {
        super(327680);
        this.values = values;
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        this.values.add(new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    public AnnotationNode(String desc) {
        this(327680, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    static void accept(AnnotationVisitor av, String name, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v = av.visitArray(name);
                if (v != null) {
                    List array = (List)value;
                    for (int j = 0; j < array.size(); ++j) {
                        AnnotationNode.accept(v, null, array.get(j));
                    }
                    v.visitEnd();
                }
            } else {
                av.visit(name, value);
            }
        }
    }

    @Override
    public void visitEnd() {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name = (String)this.values.get(i);
                    Object value = this.values.get(i + 1);
                    AnnotationNode.accept(av, name, value);
                }
            }
            av.visitEnd();
        }
    }
}

