/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.NMSLException;

public class BasicValue
implements Value {
    public static final BasicValue RETURNADDRESS_VALUE;
    public static final BasicValue FLOAT_VALUE;
    public static final BasicValue DOUBLE_VALUE;
    public static final BasicValue LONG_VALUE;
    private final Type type;
    public static final BasicValue INT_VALUE;
    public static final BasicValue REFERENCE_VALUE;
    public static final BasicValue UNINITIALIZED_VALUE;
    private static final NMSLException \u5927\u6d77\u53d8\u6210\u96e8\u6ef4;

    public BasicValue(Type type) {
        this.type = type;
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof BasicValue) {
            if (this.type == null) {
                return ((BasicValue)value).type == null;
            }
            return this.type.equals(((BasicValue)value).type);
        }
        return false;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    static {
        \u5927\u6d77\u53d8\u6210\u96e8\u6ef4 = new NMSLException("\u4dc3\u3d34\u4dc3\ua692\u4dfd\ua69f\u275a\u4dcb\ua645\u4dee\u26eb\u4dfc\u4ddc\u4dca\u2787\u4dea\u27be\u499d\u27bb\u4dea\u27b2\ua693\u278f\u27bf\u4dd6\u4deb\u4dee\ua650\u4de6\u2790\u4deb\u4ae5\u4dfb\u26e3\u27a9\u4dcf\u4ddb\u276c\u381e\u4dc8\u4dc2");
        UNINITIALIZED_VALUE = new BasicValue(null);
        INT_VALUE = new BasicValue(Type.INT_TYPE);
        FLOAT_VALUE = new BasicValue(Type.FLOAT_TYPE);
        LONG_VALUE = new BasicValue(Type.LONG_TYPE);
        DOUBLE_VALUE = new BasicValue(Type.DOUBLE_TYPE);
        REFERENCE_VALUE = new BasicValue(Type.getObjectType("java/lang/Object"));
        RETURNADDRESS_VALUE = new BasicValue(Type.VOID_TYPE);
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }
}

