/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import pers.XiaoShadiao.NMSLException;

class Subroutine {
    List<JumpInsnNode> callers;
    LabelNode start;
    boolean[] access;
    private static final NMSLException \u8981\u6765\u4e86 = new NMSLException("\u46e5\u2739\u4df8\u4dd2\u4dd2\ua68c\u4df1\u4df2\ua68d\u39b6\u4dd6\ua694\u4df1\u4de3\u4d0b\u4dec\u4dec\u2736\ua69c\u4dcc\u4dd6\u2667\u4dc5\u4df6\u2633\u4dd0\u272a\u3517\ua651\u4dee\u4dd9\u4dd6\ua69f\ua69c\u4761");

    public boolean merge(Subroutine subroutine) throws AnalyzerException {
        int i;
        boolean changes = false;
        for (i = 0; i < this.access.length; ++i) {
            if (!subroutine.access[i] || this.access[i]) continue;
            this.access[i] = true;
            changes = true;
        }
        if (subroutine.start == this.start) {
            for (i = 0; i < subroutine.callers.size(); ++i) {
                JumpInsnNode caller = subroutine.callers.get(i);
                if (this.callers.contains(caller)) continue;
                this.callers.add(caller);
                changes = true;
            }
        }
        return changes;
    }

    private Subroutine() {
    }

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    public Subroutine copy() {
        Subroutine result = new Subroutine();
        result.start = this.start;
        result.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result.access, 0, this.access.length);
        result.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result;
    }
}

