/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.util.CheckMethodAdapter;
import pers.XiaoShadiao.NMSLException;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean named;
    private boolean end;
    private static final NMSLException \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8 = new NMSLException("\u4dd7\u4dcc\ua654\ua65a\u4df9\u4dfa\u48a0\u3b6e\u4dcc\u4de5\u4934\u4def\u4df5\u4df4\u4dcd\ua66f\u3671\u4dc0\u26af\u4dc9\u4dc8\ua649\u4ddb\u4dfd\u4ded\u4dce\u26d8\u270b\u4dc4\ua65c\u4df1\u4de4");

    private void checkName(String name) {
        if (this.named && name == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(name, desc));
    }

    public CheckAnnotationAdapter(AnnotationVisitor av) {
        this(av, true);
    }

    public void visitEnum(String name, String desc, String value) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        if (value == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(name, desc, value);
        }
    }

    public void visit(String name, Object value) {
        int sort;
        this.checkEnd();
        this.checkName(name);
        if (!(value instanceof Byte || value instanceof Boolean || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Type || value instanceof byte[] || value instanceof boolean[] || value instanceof char[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (value instanceof Type && (sort = ((Type)value).getSort()) == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(name, value);
        }
    }

    CheckAnnotationAdapter(AnnotationVisitor av, boolean named) {
        super(327680, av);
        this.named = named;
    }

    public AnnotationVisitor visitArray(String name) {
        this.checkEnd();
        this.checkName(name);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(name), false);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }
}

