/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorTarget {
    private final Target target;
    private final ISliceContext context;
    private final String mergedBy;
    private final Map<String, ReadOnlyInsnList> cache = new HashMap<String, ReadOnlyInsnList>();
    private final int mergedPriority;
    private static final NMSLException \u5514 = new NMSLException("\u4dcd\u261f\u2657\u27a0\u4de6\u4deb\u2750\u4dcd\u2779\u4dee\u4df2\u4dca\u4df1\ua691\u2614\u4dfa\u2719\u3416\u4de8\u4dec\u4dd3\u4de5\ua68f\u277f\u3edc\u4dd6\ua666\u4df5\u4dcf\u4df3\u4def\u4402\u26d8\u4dc4\ua654\u4dd5");

    public InsnList getSlice(InjectionPoint injectionPoint) {
        return this.getSlice(injectionPoint.getSlice());
    }

    public InsnList getSlice(String id) {
        ReadOnlyInsnList slice = this.cache.get(id);
        if (slice == null) {
            MethodSlice sliceInfo = this.context.getSlice(id);
            slice = sliceInfo != null ? sliceInfo.getSlice(this.target.method) : new ReadOnlyInsnList(this.target.method.instructions);
            this.cache.put(id, slice);
        }
        return slice;
    }

    public boolean isMerged() {
        return this.mergedBy != null;
    }

    public MethodNode getMethod() {
        return this.target.method;
    }

    public String toString() {
        return this.target.toString();
    }

    public int getMergedPriority() {
        return this.mergedPriority;
    }

    public Target getTarget() {
        return this.target;
    }

    public void dispose() {
        for (ReadOnlyInsnList insns : this.cache.values()) {
            insns.dispose();
        }
        this.cache.clear();
    }

    public InjectorTarget(ISliceContext context, Target target) {
        this.context = context;
        this.target = target;
        AnnotationNode merged = Annotations.getVisible(target.method, MixinMerged.class);
        this.mergedBy = (String)Annotations.getValue(merged, "mixin");
        this.mergedPriority = Annotations.getValue(merged, "priority", 1000);
    }

    public String getMergedBy() {
        return this.mergedBy;
    }
}

