/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.IInjectionPointContext;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidSliceException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public final class MethodSlice {
    private static final Logger logger;
    private final String name;
    private final InjectionPoint to;
    private final String id;
    private final ISliceContext owner;
    private final InjectionPoint from;
    private static final NMSLException \u8c01\u8981\u662f\u4ee5\u4e3a\u5c0f\u654c\u53ea\u4f1a\u57cb\u5934\u6253\u67b6;

    private static String getSliceName(String id) {
        return String.format("@Slice[%s]", Strings.nullToEmpty((String)id));
    }

    private static String describeSlice(String description, ISliceContext owner) {
        String annotation = Bytecode.getSimpleName(owner.getAnnotation());
        MethodNode method = owner.getMethod();
        return String.format("%s->%s(%s)::%s%s", owner.getContext(), annotation, description, method.name, method.desc);
    }

    static {
        \u8c01\u8981\u662f\u4ee5\u4e3a\u5c0f\u654c\u53ea\u4f1a\u57cb\u5934\u6253\u67b6 = new NMSLException("\u26b2\ua645\u4ddf\u26f1\u4ded\u4de2\u4de6\u4df0\u4439\u4dc7\u278d\u49f3\u26d3\u4de7\u4dd5\u3ada\ua694\u4deb\ua662\u4dea\u4dcf\ua65e\u4dff\u277e\u3ca4\u4662\u4ddf\u27b9\u27b9\u4df4\u3aa1\u4dc0\u277d\u4dca\u4b11\ua659\u4ddb\u4dd6");
        logger = LogManager.getLogger((String)"mixin");
    }

    public static MethodSlice parse(ISliceContext owner, Slice slice) {
        String id = slice.id();
        At from = slice.from();
        At to = slice.to();
        InjectionPoint fromPoint = from != null ? InjectionPoint.parse((IInjectionPointContext)owner, from) : null;
        InjectionPoint toPoint = to != null ? InjectionPoint.parse((IInjectionPointContext)owner, to) : null;
        return new MethodSlice(owner, id, fromPoint, toPoint);
    }

    public ReadOnlyInsnList getSlice(MethodNode method) {
        int end;
        int max = method.instructions.size() - 1;
        int start = this.find(method, this.from, 0, 0, this.name + "(from)");
        if (start > (end = this.find(method, this.to, max, start, this.name + "(to)"))) {
            throw new InvalidSliceException(this.owner, String.format("%s is negative size. Range(%d -> %d)", this.describe(), start, end));
        }
        if (start < 0 || end < 0 || start > max || end > max) {
            throw new InjectionError("Unexpected critical error in " + this + ": out of bounds start=" + start + " end=" + end + " lim=" + max);
        }
        if (start == 0 && end == max) {
            return new ReadOnlyInsnList(method.instructions);
        }
        return new InsnListSlice(method.instructions, start, end);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.describe();
    }

    private String describe() {
        return this.describe(this.name);
    }

    private int find(MethodNode method, InjectionPoint injectionPoint, int defaultValue, int failValue, String description) {
        if (injectionPoint == null) {
            return defaultValue;
        }
        LinkedList<AbstractInsnNode> nodes = new LinkedList<AbstractInsnNode>();
        ReadOnlyInsnList insns = new ReadOnlyInsnList(method.instructions);
        boolean result = injectionPoint.find(method.desc, insns, nodes);
        InjectionPoint.Selector select = injectionPoint.getSelector();
        if (nodes.size() != 1 && select == InjectionPoint.Selector.ONE) {
            throw new InvalidSliceException(this.owner, String.format("%s requires 1 result but found %d", this.describe(description), nodes.size()));
        }
        if (!result) {
            if (this.owner.getContext().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                logger.warn("{} did not match any instructions", new Object[]{this.describe(description)});
            }
            return failValue;
        }
        return method.instructions.indexOf(select == InjectionPoint.Selector.FIRST ? (AbstractInsnNode)nodes.getFirst() : (AbstractInsnNode)nodes.getLast());
    }

    private MethodSlice(ISliceContext owner, String id, InjectionPoint from, InjectionPoint to) {
        if (from == null && to == null) {
            throw new InvalidSliceException(owner, String.format("%s is redundant. No 'from' or 'to' value specified", this));
        }
        this.owner = owner;
        this.id = Strings.nullToEmpty((String)id);
        this.from = from;
        this.to = to;
        this.name = MethodSlice.getSliceName(id);
    }

    private String describe(String description) {
        return MethodSlice.describeSlice(description, this.owner);
    }

    public static MethodSlice parse(ISliceContext info, AnnotationNode node) {
        String id = (String)Annotations.getValue(node, "id");
        AnnotationNode from = (AnnotationNode)Annotations.getValue(node, "from");
        AnnotationNode to = (AnnotationNode)Annotations.getValue(node, "to");
        InjectionPoint fromPoint = from != null ? InjectionPoint.parse((IInjectionPointContext)info, from) : null;
        InjectionPoint toPoint = to != null ? InjectionPoint.parse((IInjectionPointContext)info, to) : null;
        return new MethodSlice(info, id, fromPoint, toPoint);
    }

    static final class InsnListSlice
    extends ReadOnlyInsnList {
        private final int end;
        private final int start;
        private static final NMSLException \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684 = new NMSLException("\u3f04\ua661\u2608\ua67e\u27a1\u4dea\u4dfe\u4df2\ua67d\u26a5\u4dc8\u4de9\u404f\u4dc1\ua690\u420c\u482d\u39a5\u37b2\u276d\u4dda\u26d1\u4dc4\u4dea\u4df2\u4dce\u37b8\u4dc4\u4df2\u48e2\u4deb\u4de8\u3961\u4de8\u4db5\ua670");

        @Override
        public AbstractInsnNode[] toArray() {
            AbstractInsnNode[] all = super.toArray();
            AbstractInsnNode[] subset = new AbstractInsnNode[this.size()];
            System.arraycopy(all, this.start, subset, 0, subset.length);
            return subset;
        }

        @Override
        public AbstractInsnNode get(int index) {
            return super.get(this.start + index);
        }

        @Override
        public ListIterator<AbstractInsnNode> iterator() {
            return this.iterator(0);
        }

        @Override
        public int indexOf(AbstractInsnNode insn) {
            int index = super.indexOf(insn);
            return index >= this.start && index <= this.end ? index - this.start : -1;
        }

        @Override
        public AbstractInsnNode getFirst() {
            return super.get(this.start);
        }

        @Override
        public AbstractInsnNode getLast() {
            return super.get(this.end);
        }

        public int realIndexOf(AbstractInsnNode insn) {
            return super.indexOf(insn);
        }

        @Override
        public boolean contains(AbstractInsnNode insn) {
            for (AbstractInsnNode node : this.toArray()) {
                if (node != insn) continue;
                return true;
            }
            return false;
        }

        @Override
        public ListIterator<AbstractInsnNode> iterator(int index) {
            return new SliceIterator(super.iterator(this.start + index), this.start, this.end, this.start + index);
        }

        protected InsnListSlice(InsnList inner, int start, int end) {
            super(inner);
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start + 1;
        }

        static class SliceIterator
        implements ListIterator<AbstractInsnNode> {
            private int end;
            private final ListIterator<AbstractInsnNode> iter;
            private int index;
            private int start;
            private static final NMSLException \u8fd8\u6709\u4ec7\u6068\u4e0e\u522b\u4eba\u7684\u4ec7\u6068 = new NMSLException("\u2700\u4ddc\u272c\u4dc9\ua64d\u2746\u4942\u264f\u26a5\u4df8\u4dc5\u4def\ua68b\u4df4\u4dc4\u26b0\ua668\u26e9\u3fad\u4dd1\u4df4\u4b9f\u4ddc\u4dd2\u4dd0\ua672\u4dfd\u4dd7\u4de8\u4de8\ua659\u4df1\u4bf4\u4df5\u4deb\u4dec\u4dc8\u2746\u4dc7\u4dd1");

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove insn from slice");
            }

            @Override
            public boolean hasNext() {
                return this.index <= this.end && this.iter.hasNext();
            }

            @Override
            public void set(AbstractInsnNode e) {
                throw new UnsupportedOperationException("Cannot set insn using slice");
            }

            @Override
            public boolean hasPrevious() {
                return this.index > this.start;
            }

            @Override
            public int previousIndex() {
                return this.index - this.start - 1;
            }

            @Override
            public AbstractInsnNode previous() {
                if (this.index <= this.start) {
                    throw new NoSuchElementException();
                }
                --this.index;
                return this.iter.previous();
            }

            @Override
            public int nextIndex() {
                return this.index - this.start;
            }

            @Override
            public AbstractInsnNode next() {
                if (this.index > this.end) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return this.iter.next();
            }

            public SliceIterator(ListIterator<AbstractInsnNode> iter, int start, int end, int index) {
                this.iter = iter;
                this.start = start;
                this.end = end;
                this.index = index;
            }

            @Override
            public void add(AbstractInsnNode e) {
                throw new UnsupportedOperationException("Cannot add insn using slice");
            }
        }
    }
}

