/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidSliceException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public final class MethodSlices {
    private final InjectionInfo info;
    private final Map<String, MethodSlice> slices = new HashMap<String, MethodSlice>(4);
    private static final NMSLException \u963f\u96c5\u5979 = new NMSLException("\ua677\u4dc8\u4dda\u4dc6\u2705\u4de5\u2694\u4dcf\u4de9\u2681\u2751\u271d\ua640\u4ddb\u4deb\u4df3\u4dc5\u2705\u2603\ua64e\u26d4\u2794\u27bf\u4de3\u3e39\u4868\u4dd1\ua69a\u4df1\u4dcd\u26a9\ua65f\u26fc\u4de8\u26f0\ua69e\u265a\u38dc\ua685\u4dfc\u3587\u2699\u26d4\u4df3");

    public static MethodSlices parse(InjectionInfo info) {
        MethodSlices slices = new MethodSlices(info);
        AnnotationNode annotation = info.getAnnotation();
        if (annotation != null) {
            for (AnnotationNode node : Annotations.getValue(annotation, "slice", true)) {
                MethodSlice slice = MethodSlice.parse((ISliceContext)info, node);
                slices.add(slice);
            }
        }
        return slices;
    }

    private MethodSlices(InjectionInfo info) {
        this.info = info;
    }

    public String toString() {
        return String.format("MethodSlices%s", this.slices.keySet());
    }

    public MethodSlice get(String id) {
        return this.slices.get(id);
    }

    private void add(MethodSlice slice) {
        String id = this.info.getSliceId(slice.getId());
        if (this.slices.containsKey(id)) {
            throw new InvalidSliceException((ISliceContext)this.info, slice + " has a duplicate id, '" + id + "' was already defined");
        }
        this.slices.put(id, slice);
    }
}

