/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.invoke;

import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import pers.XiaoShadiao.NMSLException;

public abstract class InvokeInjector
extends Injector {
    protected final String annotationType;
    private static final NMSLException \u6211\u4eec\u5df2\u7ecf\u8d70\u4e86\u8fd9\u4e48\u8fdc = new NMSLException("\u4dec\u4dc1\u273c\u260a\u4df5\u4de0\u3569\u2709\ua663\u4dc3\ua690\u4ddb\u4df6\u4dc9\u4dda\ua67f\ua665\u4dfd\u4dd3\ua68c\u4dd2\ua65e\u4df2\ua689\u261a\u4dcf\u273c\u4de1\u2794\u4947\u4dd8\u4dd8\u4dea\u4de9\u4df1\u4df6\u4de8\u4dc8\u4dd7\u2608\u4dc7\ua69d\u4dc4\u4def\u2784\u4dc3\u26af\u4dd4");

    protected void storeArgs(Type[] args, InsnList insns, int[] argMap, int start, int end) {
        for (int arg = end - 1; arg >= start; --arg) {
            insns.add(new VarInsnNode(args[arg].getOpcode(54), argMap[arg]));
        }
    }

    protected void checkTarget(Target target) {
        this.checkTargetModifiers(target, true);
    }

    protected int[] storeArgs(Target target, Type[] args, InsnList insns, int start) {
        int[] argMap = target.generateArgMap(args, start);
        this.storeArgs(args, insns, argMap, start, args.length);
        return argMap;
    }

    protected void pushArgs(Type[] args, InsnList insns, int[] argMap, int start, int end) {
        for (int arg = start; arg < end; ++arg) {
            insns.add(new VarInsnNode(args[arg].getOpcode(21), argMap[arg]));
        }
    }

    @Override
    protected void sanityCheck(Target target, List<InjectionPoint> injectionPoints) {
        super.sanityCheck(target, injectionPoints);
        this.checkTarget(target);
    }

    protected abstract void injectAtInvoke(Target var1, InjectionNodes.InjectionNode var2);

    public InvokeInjector(InjectionInfo info, String annotationType) {
        super(info);
        this.annotationType = annotationType;
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        if (!(node.getCurrentTarget() instanceof MethodInsnNode)) {
            throw new InvalidInjectionException(this.info, this.annotationType + " annotation on is targetting a non-method insn in " + target + " in " + this);
        }
        this.injectAtInvoke(target, node);
    }

    protected AbstractInsnNode invokeHandlerWithArgs(Type[] args, InsnList insns, int[] argMap, int startArg, int endArg) {
        if (!this.isStatic) {
            insns.add(new VarInsnNode(25, 0));
        }
        this.pushArgs(args, insns, argMap, startArg, endArg);
        return this.invokeHandler(insns);
    }

    protected AbstractInsnNode invokeHandlerWithArgs(Type[] args, InsnList insns, int[] argMap) {
        return this.invokeHandlerWithArgs(args, insns, argMap, 0, args.length);
    }

    protected void checkTargetForNode(Target target, InjectionNodes.InjectionNode node) {
        if (target.isCtor) {
            MethodInsnNode superCall = target.findSuperInitNode();
            int superCallIndex = target.indexOf(superCall);
            int targetIndex = target.indexOf(node.getCurrentTarget());
            if (targetIndex <= superCallIndex) {
                if (!this.isStatic) {
                    throw new InvalidInjectionException(this.info, "Pre-super " + this.annotationType + " invocation must be static in " + this);
                }
                return;
            }
        }
        this.checkTargetModifiers(target, true);
    }

    protected final void checkTargetModifiers(Target target, boolean exactMatch) {
        if (exactMatch && target.isStatic != this.isStatic) {
            throw new InvalidInjectionException(this.info, "'static' modifier of handler method does not match target in " + this);
        }
        if (!exactMatch && !this.isStatic && target.isStatic) {
            throw new InvalidInjectionException(this.info, "non-static callback method " + this + " targets a static method which is not supported");
        }
    }
}

