/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final int ordinal;
    private final int opcode;
    private final LocalVariableDiscriminator discriminator;
    private boolean opcodeAfter;
    private final Type returnType;
    private static final NMSLException \u6211\u62cd\u4e5d = new NMSLException("\u4857\u4df3\u2762\u2789\u2715\u47bc\u4df5\u4dd5\u4df7\u4de1\u4dee\u4dfe\u4dfa\u26f7\u4dce\u277a\u4dd4\ua665\u4dde\u4de0\ua689\ua646\u272a\u2772\u4dff\u4df2\u4dc2\u4dcf\u4dc5\u4dcb\u3950\u4dc2");

    protected BeforeLoadLocal(InjectionPointData data) {
        this(data, 21, false);
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> nodes) {
        SearchState state = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> iter = target.method.instructions.iterator();
        while (iter.hasNext()) {
            int local;
            AbstractInsnNode insn = iter.next();
            if (state.isPendingCheck()) {
                local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
                state.check(nodes, insn, local);
                continue;
            }
            if (!(insn instanceof VarInsnNode) || insn.getOpcode() != this.opcode || this.ordinal != -1 && state.success()) continue;
            state.register((VarInsnNode)insn);
            if (this.opcodeAfter) {
                state.setPendingCheck();
                continue;
            }
            local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
            state.check(nodes, insn, local);
        }
        return state.success();
    }

    protected BeforeLoadLocal(InjectionPointData data, int opcode, boolean opcodeAfter) {
        super(data.getContext());
        this.returnType = data.getMethodReturnType();
        this.discriminator = data.getLocalVariableDiscriminator();
        this.opcode = data.getOpcode(this.returnType.getOpcode(opcode));
        this.ordinal = data.getOrdinal();
        this.opcodeAfter = opcodeAfter;
    }

    static class SearchState {
        private final int targetOrdinal;
        private final boolean print;
        private boolean found = false;
        private boolean pendingCheck = false;
        private VarInsnNode varNode;
        private int ordinal = 0;
        private static final NMSLException \u8981\u662f\u4ed6\u4e0d\u8bf4 = new NMSLException("\u269c\u4dd6\u4de3\u2607\u4dd8\u4dcf\u4ddd\u4dc6\u4dcb\u4dc4\ua67c\u4dd3\u275d\ua682\u4def\u40cc\ua64b\u4dde\u4de5\u4ddb\u4dd4\u26bc\u4722\ua642\u2626\u4dc8\u4dd0\u4de6\u2732\u2628\u4dcf\u4de9\u271b\u4dc8\u4dd7\ua64e\u4dc4\ua693\u4dfc\u4dd2\u4dd2");

        boolean success() {
            return this.found;
        }

        SearchState(int targetOrdinal, boolean print) {
            this.targetOrdinal = targetOrdinal;
            this.print = print;
        }

        void register(VarInsnNode node) {
            this.varNode = node;
        }

        void setPendingCheck() {
            this.pendingCheck = true;
        }

        void check(Collection<AbstractInsnNode> nodes, AbstractInsnNode insn, int local) {
            this.pendingCheck = false;
            if (!(local == this.varNode.var || local <= -2 && this.print)) {
                return;
            }
            if (this.targetOrdinal == -1 || this.targetOrdinal == this.ordinal) {
                nodes.add(insn);
                this.found = true;
            }
            ++this.ordinal;
            this.varNode = null;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }
    }
}

