/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="JUMP")
public class JumpInsnPoint
extends InjectionPoint {
    private final int ordinal;
    private final int opCode;
    private static final NMSLException \u4e0d\u6015\u4e0d\u6015 = new NMSLException("\u4de4\u26ae\ua675\u27a3\u4dcd\u26b5\u4de7\u2703\ua66a\u4dff\u4dec\ua656\u4df7\u4dcf\u4de2\ua669\u4dd2\u35bf\ua699\u268c\u4dd6\ua65f\u2770\u4dfb\u3d40\u4dc8\u269c\u4dfb\u4ddc\u2610\u2688\u2783\u4dc9\ua680\ua68f\u4de1\ua654");

    public JumpInsnPoint(InjectionPointData data) {
        this.opCode = data.getOpcode(-1, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 198, 199, -1);
        this.ordinal = data.getOrdinal();
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int ordinal = 0;
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (!(insn instanceof JumpInsnNode) || this.opCode != -1 && insn.getOpcode() != this.opCode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }
}

