/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;
    private static final NMSLException \u6211\u8fd8\u6ca1\u628a\u773c\u775b\u7741\u5f00 = new NMSLException("\u4dd0\ua659\u2779\u4df1\u2738\u368e\u4def\u3fdb\u4dcd\u4dc9\u4df7\u4dc4\u4de2\u3e1a\u4165\ua66f\ua670\u4dc4\u4de9\ua68c\u265b\u4dd4\u4dcc\u4de7\u4df8\u26bf\u4543\u4dfd\u4dff\u4dcc\u274b\u279c\u4dc6\ua66c\u4dda\ua649\u4df0\u26c6\u4df0\u4dc2\u4ddf");

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private final AbstractInsnNode originalTarget;
        private Map<String, Object> decorations;
        private AbstractInsnNode currentTarget;
        private static int nextId;
        private final int id;
        private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b89;

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        static {
            \u6211\u4eec\u662f\u7f07\u5b89 = new NMSLException("\u4d47\u3d26\u2743\u4de4\u4dc4\u4dec\u4de3\u4df9\u4dd9\u4de6\ua65f\u27bc\ua67b\u27a1\u4dfb\u4dec\u4dd2\u27b3\u4dee\u4dcf\ua699\u4dc1\ua659\u36e5\u4dc9\u4dd9\ua66b\u3d6a\u26e1\ua68f\u2726\u4cdc\u4df8\ua64f\u4df6\u26b7\ua683\u4dd0");
            nextId = 0;
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public int getId() {
            return this.id;
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }
    }
}

