/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorGroupInfo {
    private int minCallbackCount = -1;
    private final String name;
    private final boolean isDefault;
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private int maxCallbackCount = Integer.MAX_VALUE;
    private static final NMSLException \u6211\u662f\u7f07\u5b9d = new NMSLException("\u4dde\u265d\u4dff\u4ddc\u275a\u2745\u2677\ua65c\ua69e\u2785\u26a1\u4de2\u4dcf\u4ddd\u2725\u4dd0\u4ddb\u4de5\u4df8\u4dde\ua699\u4dea\u4dc5\u270a\u4df8\u4df9\u4dfa\ua68a\u4dc6\u4dfa\u4dd6\u4de6\u276f\ua67d\u4df8");

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int total = 0;
        for (InjectionInfo member : this.members) {
            total += member.getInjectedCallbackCount();
        }
        int min = this.getMinRequired();
        int max = this.getMaxAllowed();
        if (total < min) {
            throw new InjectionValidationException(this, String.format("expected %d invocation(s) but only %d succeeded", min, total));
        }
        if (total > max) {
            throw new InjectionValidationException(this, String.format("maximum of %d invocation(s) allowed but %d succeeded", max, total));
        }
        return this;
    }

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 1);
    }

    public String getName() {
        return this.name;
    }

    InjectorGroupInfo(String name, boolean flag) {
        this.name = name;
        this.isDefault = flag;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, Integer.MAX_VALUE);
    }

    public String toString() {
        return String.format("@Group(name=%s, min=%d, max=%d)", this.getName(), this.getMinRequired(), this.getMaxAllowed());
    }

    public InjectorGroupInfo(String name) {
        this(name, false);
    }

    public void setMaxAllowed(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group max count. Attempted to set max=" + max + " on " + this);
        }
        if (this.maxCallbackCount < Integer.MAX_VALUE && this.maxCallbackCount != max) {
            LogManager.getLogger((String)"mixin").warn("Conflicting max value '{}' on @Group({}), previously specified {}", new Object[]{max, this.name, this.maxCallbackCount});
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, max);
    }

    public void setMinRequired(int min) {
        if (min < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group min count. Attempted to set min=" + min + " on " + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != min) {
            LogManager.getLogger((String)"mixin").warn("Conflicting min value '{}' on @Group({}), previously specified {}", new Object[]{min, this.name, this.minCallbackCount});
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, min);
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public InjectorGroupInfo add(InjectionInfo member) {
        this.members.add(member);
        return this;
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final long serialVersionUID = 1L;
        private static final InjectorGroupInfo NO_GROUP;
        private static final NMSLException \u8bba\u529b\u91cf;

        @Override
        public InjectorGroupInfo get(Object key) {
            return this.forName(key.toString());
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotation, String defaultGroup) {
            Integer max;
            if (annotation == null) {
                return NO_GROUP;
            }
            String name = (String)Annotations.getValue(annotation, "name");
            if (name == null || name.isEmpty()) {
                name = defaultGroup;
            }
            InjectorGroupInfo groupInfo = this.forName(name);
            Integer min = (Integer)Annotations.getValue(annotation, "min");
            if (min != null && min != -1) {
                groupInfo.setMinRequired(min);
            }
            if ((max = (Integer)Annotations.getValue(annotation, "max")) != null && max != -1) {
                groupInfo.setMaxAllowed(max);
            }
            return groupInfo;
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo group : this.values()) {
                group.validate();
            }
        }

        public InjectorGroupInfo forName(String name) {
            InjectorGroupInfo value = (InjectorGroupInfo)super.get(name);
            if (value == null) {
                value = new InjectorGroupInfo(name);
                this.put(name, value);
            }
            return value;
        }

        public InjectorGroupInfo parseGroup(MethodNode method, String defaultGroup) {
            return this.parseGroup(Annotations.getInvisible(method, Group.class), defaultGroup);
        }

        static {
            \u8bba\u529b\u91cf = new NMSLException("\u4a35\u4df3\u4df7\u4d8e\u4dea\u4ddd\u4def\u4dcf\u4ae3\u4df2\u266a\u27a4\u4de3\u262d\u262a\u4de7\u3d71\ua69a\u4ddb\u37ac\u4ddd\u4dd7\u4df4\u4dde\u4df7\u4dd3\u4dd3\ua677\u4dec\u4873\u4de2\u4ddd\ua666\u4dca\u4de4\u4df1\ua667");
            NO_GROUP = new InjectorGroupInfo("NONE", true);
        }
    }
}

