/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import pers.XiaoShadiao.NMSLException;

public final class RemappingReferenceMapper
implements IReferenceMapper {
    private final Map<String, String> mappings;
    private final IReferenceMapper refMap;
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> srgs;
    private static final Logger logger;
    private static final String DEFAULT_MAPPING_ENV = "searge";
    private static final String DEFAULT_RESOURCE_PATH_PROPERTY = "net.minecraftforge.gradle.GradleStart.srg.srg-mcp";
    private static final NMSLException \u592a\u597d\u5566;

    private static String getResource(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE);
        return Strings.isNullOrEmpty((String)resource) ? System.getProperty(DEFAULT_RESOURCE_PATH_PROPERTY) : resource;
    }

    private Map<String, String> getCache(String className) {
        Map<String, String> classCache = this.cache.get(className);
        if (classCache == null) {
            classCache = new HashMap<String, String>();
            this.cache.put(className, classCache);
        }
        return classCache;
    }

    @Override
    public String remapWithContext(String context, String className, String reference) {
        return this.refMap.remapWithContext(context, className, reference);
    }

    @Override
    public String getContext() {
        return this.refMap.getContext();
    }

    private static String getMappingEnv(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV);
        return Strings.isNullOrEmpty((String)resource) ? DEFAULT_MAPPING_ENV : resource;
    }

    @Override
    public boolean isDefault() {
        return this.refMap.isDefault();
    }

    static {
        \u592a\u597d\u5566 = new NMSLException("\u268d\u4def\u2678\u4dd8\u2645\u4dc1\u4df9\u4dfb\u4a5f\u4de1\u4d1b\u4dc0\u4df2\u266b\u4ddf\u4de9\u26d0\u4dd6\u4c6d\u2786\u4dc5\u4dff\u3e2a\u2711\ua693\ua65a\u27a4\u4dc9\u3f9b\u4df4\u4df4\ua672\u2625\u4df3\u46fb\u274b\u2740");
        logger = LogManager.getLogger((String)"mixin");
        srgs = new HashMap<String, Map<String, String>>();
    }

    private static Map<String, String> loadSrgs(String fileName) {
        if (srgs.containsKey(fileName)) {
            return srgs.get(fileName);
        }
        final HashMap<String, String> map = new HashMap<String, String>();
        srgs.put(fileName, map);
        File file = new File(fileName);
        if (!file.isFile()) {
            return map;
        }
        try {
            Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Object>(){
                private static final NMSLException \u5927\u574f\u86cb = new NMSLException("\u3b55\u4892\u3517\u4dfc\u4ddf\u26fb\u4dde\u49ce\u4de5\u47ea\u4df7\u3aac\ua69a\u4de9\u26cc\u4dfb\u4de5\u37a8\ua696\u272d\u4df9\u2659\u4dd7\u4dee\u39e2\ua67f\u276f\u4dc7\u2631\u4de3\u2776\u4dd0\u4def\u4deb\u4dd0\u4dd8\u4634\u4de1\u4ac1\u4dd3\u4dfc\u4dfb\u2786\ua69b\u2781\u4ddd\u4df3\u4dc4");

                public boolean processLine(String line) throws IOException {
                    if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) {
                        return true;
                    }
                    int fromPos = 0;
                    int toPos = 0;
                    if ((line.startsWith("MD: ") ? 2 : (toPos = line.startsWith("FD: ") ? 1 : 0)) > 0) {
                        String[] entries = line.substring(4).split(" ", 4);
                        map.put(entries[fromPos].substring(entries[fromPos].lastIndexOf(47) + 1), entries[toPos].substring(entries[toPos].lastIndexOf(47) + 1));
                    }
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (IOException ex) {
            logger.warn("Could not read input SRG file: {}", new Object[]{fileName});
            logger.catching((Throwable)ex);
        }
        return map;
    }

    public static IReferenceMapper of(MixinEnvironment env, IReferenceMapper refMap) {
        if (!refMap.isDefault() && RemappingReferenceMapper.hasData(env)) {
            return new RemappingReferenceMapper(env, refMap);
        }
        return refMap;
    }

    @Override
    public String remap(String className, String reference) {
        Map<String, String> classCache = this.getCache(className);
        String remapped = classCache.get(reference);
        if (remapped == null) {
            remapped = this.refMap.remap(className, reference);
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                remapped = remapped.replace(entry.getKey(), entry.getValue());
            }
            classCache.put(reference, remapped);
        }
        return remapped;
    }

    @Override
    public void setContext(String context) {
    }

    @Override
    public String getResourceName() {
        return this.refMap.getResourceName();
    }

    @Override
    public String getStatus() {
        return this.refMap.getStatus();
    }

    private RemappingReferenceMapper(MixinEnvironment env, IReferenceMapper refMap) {
        this.refMap = refMap;
        this.refMap.setContext(RemappingReferenceMapper.getMappingEnv(env));
        String resource = RemappingReferenceMapper.getResource(env);
        this.mappings = RemappingReferenceMapper.loadSrgs(resource);
        logger.info("Remapping refMap {} using {}", new Object[]{refMap.getResourceName(), resource});
    }

    private static boolean hasData(MixinEnvironment env) {
        String fileName = RemappingReferenceMapper.getResource(env);
        return fileName != null && new File(fileName).exists();
    }
}

