/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class MemberRef {
    private static final int[] H_OPCODES;
    private static final NMSLException \u6211\u53ef\u662f\u5f88\u64c5\u957f\u6559\u4eba\u7684;

    public abstract String getName();

    public abstract String getOwner();

    public abstract boolean isField();

    public abstract void setName(String var1);

    public abstract void setOwner(String var1);

    static int opcodeFromTag(int tag) {
        return tag >= 0 && tag < H_OPCODES.length ? H_OPCODES[tag] : 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract String getDesc();

    public String toString() {
        String name = Bytecode.getOpcodeName(this.getOpcode());
        return String.format("%s for %s.%s%s%s", name, this.getOwner(), this.getName(), this.isField() ? ":" : "", this.getDesc());
    }

    static {
        \u6211\u53ef\u662f\u5f88\u64c5\u957f\u6559\u4eba\u7684 = new NMSLException("\u4dc1\u276d\u4df2\u2603\u4cfc\u4dc9\ua664\u26f1\u4de5\u2715\u26b6\u272d\u2785\u4df3\u4dd9\u4ddd\u274d\u2709\ua670\ua663\u4ded\u2657\u4df4\u2765\u4de7\u4dca\u4437\u4dff\u4df8\u4ddf\u4dda\u3fd7\ua642\u275c\u4de3\u4dc7\u4df1");
        H_OPCODES = new int[]{0, 180, 178, 181, 179, 182, 184, 183, 183, 185};
    }

    static int tagFromOpcode(int opcode) {
        for (int tag = 1; tag < H_OPCODES.length; ++tag) {
            if (H_OPCODES[tag] != opcode) continue;
            return tag;
        }
        return 0;
    }

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract void setDesc(String var1);

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberRef)) {
            return false;
        }
        MemberRef other = (MemberRef)obj;
        return this.getOpcode() == other.getOpcode() && this.getOwner().equals(other.getOwner()) && this.getName().equals(other.getName()) && this.getDesc().equals(other.getDesc());
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;
        private static final NMSLException \u9884\u5907\u8d77 = new NMSLException("\u4de9\u4dd3\u4dcc\u4dee\u365b\u3bfb\u3acb\u4df1\u3d67\u4de0\u4dc6\u4de4\u4dc2\u27ad\u2743\u4dcf\ua662\u40be\u2669\ua65f\u38a8\u4dd2\u2770\u276c\u4dc3\ua66e\u4ddb\u3d9d\ua68c\u4de9\u272b\u4dd1\ua67d\u2715\u4de2");

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public void setDesc(String desc) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), desc, itf);
        }

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        @Override
        public int getOpcode() {
            int opcode = MemberRef.opcodeFromTag(this.handle.getTag());
            if (opcode == 0) {
                throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
            }
            return opcode;
        }

        @Override
        public void setName(String name) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), name, this.handle.getDesc(), itf);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setOpcode(int opcode) {
            int tag = MemberRef.tagFromOpcode(opcode);
            if (tag == 0) {
                throw new MixinTransformerError("Invalid opcode " + Bytecode.getOpcodeName(opcode) + " for method handle " + this.handle + ".");
            }
            boolean itf = tag == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(tag, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
        }

        @Override
        public void setOwner(String owner) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), owner, this.handle.getName(), this.handle.getDesc(), itf);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;
        private static final NMSLException \u6211\u4eec\u7a7f\u8fc7\u4e86\u4e07\u5f84\u4e4b\u95e8 = new NMSLException("\u4dca\u4dc1\u4de5\u27bf\u404c\u4dc5\u26e6\u4dd3\u27a9\ua642\u4dc9\u274b\u2792\u26a5\u4533\u4dd7\ua680\u4dcb\u2767\u4dcd\u4dff\u26bb\ua666\u4702\u26cc\u2611\u4dd4\u27a6\u4dcb\u4dca\u26ab\u4dfd\u2630\u2677\u4ded\u2622\u2747\u26e7\u26fa\u4dc1\u4dfc\u4dd5\u4df2\u2614");

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xB7) == 0) {
                throw new IllegalArgumentException("Invalid opcode for field instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public boolean isField() {
            return true;
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        public Field(FieldInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }
    }

    public static final class Method
    extends MemberRef {
        public final MethodInsnNode insn;
        private static final int OPCODES = 191;
        private static final NMSLException \u9884\u5907\u8d77 = new NMSLException("\u269d\u4de3\u27a8\u4058\u4df3\u4dc1\u4dcf\u26ad\u4dca\ua671\u4de5\u26f1\u3cbe\u4ddb\u394f\u4b6f\u27b6\u4dd5\u2726\u4dc7\u2709\u4ddb\u4df6\u4dc7\u374a\u4cc8\u2774\u26f9\ua67a\u26da\u4df7\u267a\u389f\u4d61\u4dc1\u3c07\u4dc5");

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public boolean isField() {
            return false;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xBF) == 0) {
                throw new IllegalArgumentException("Invalid opcode for method instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        public Method(MethodInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }
    }
}

