/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class SourceMap {
    private final String sourceFile;
    private static final String DEFAULT_STRATUM = "Mixin";
    private final Map<String, Stratum> strata = new LinkedHashMap<String, Stratum>();
    private static final String NEWLINE = "\n";
    private int nextLineOffset = 1;
    private String defaultStratum = "Mixin";
    private static final NMSLException \u5c0f\u767d\u5440 = new NMSLException("\u3d69\u272d\u26ab\u26f7\ua65a\u4dc0\u4de6\u26d6\u4de0\u46f8\u2658\u27a7\u4dd1\u27aa\u4dd7\u4dcf\u4dd9\ua655\u41b3\u265f\u38d6\u4dcb\u2691\u4dca\u4ded\u4cda\u26fb\u26da\u3551\u2697\u4dfb\u4de6\u4df0\u277e\ua654\u277b\u3742\ua66d\u4dcf\ua69c\u4dcd\u4dfa");

    public File addFile(String stratumName, String sourceFileName, String sourceFilePath, int size) {
        Stratum stratum = this.strata.get(stratumName);
        if (stratum == null) {
            stratum = new Stratum(stratumName);
            this.strata.put(stratumName, stratum);
        }
        File file = stratum.addFile(this.nextLineOffset, size, sourceFileName, sourceFilePath);
        this.nextLineOffset += size;
        return file;
    }

    private void appendTo(StringBuilder sb) {
        sb.append("SMAP").append(NEWLINE);
        sb.append(this.getSourceFile()).append(NEWLINE);
        sb.append(this.defaultStratum).append(NEWLINE);
        for (Stratum stratum : this.strata.values()) {
            stratum.appendTo(sb);
        }
        sb.append("*E").append(NEWLINE);
    }

    public File addFile(ClassNode classNode) {
        return this.addFile(this.defaultStratum, classNode);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    public SourceMap(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getPseudoGeneratedSourceFile() {
        return this.sourceFile.replace(".java", "$mixin.java");
    }

    public File addFile(String stratumName, ClassNode classNode) {
        return this.addFile(stratumName, classNode.sourceFile, classNode.name + ".java", Bytecode.getMaxLineNumber(classNode, 500, 50));
    }

    public File addFile(String sourceFileName, String sourceFilePath, int size) {
        return this.addFile(this.defaultStratum, sourceFileName, sourceFilePath, size);
    }

    static class Stratum {
        public final String name;
        private static final String STRATUM_MARK = "*S";
        private static final String LINES_MARK = "*L";
        private static final String FILE_MARK = "*F";
        private final Map<String, File> files = new LinkedHashMap<String, File>();
        private static final NMSLException \u6709\u6211\u4eec\u5728 = new NMSLException("\u269e\u4dcd\u2710\u26d0\ua673\u4df3\u26cd\u4dc8\u275b\u4df8\ua65e\u4def\u4de4\ua66e\u2631\ua642\ua656\ua68d\u4df2\u4de8\u4dc8\u2717\u4def\u27b4\u2700\u353b\u4dd2\u26a8\u2788\u2693\u4de2\u4dc8\u2797\u4dc0\u4ddc\u2697");

        public Stratum(String name) {
            this.name = name;
        }

        void appendTo(StringBuilder sb) {
            sb.append(STRATUM_MARK).append(" ").append(this.name).append(SourceMap.NEWLINE);
            sb.append(FILE_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendFile(sb);
            }
            sb.append(LINES_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendLines(sb);
            }
        }

        public File addFile(int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            File file = this.files.get(sourceFilePath);
            if (file == null) {
                file = new File(this.files.size() + 1, lineOffset, size, sourceFileName, sourceFilePath);
                this.files.put(sourceFilePath, file);
            }
            return file;
        }
    }

    public static class File {
        public final int lineOffset;
        public final int size;
        public final String sourceFileName;
        public final String sourceFilePath;
        public final int id;
        private static final NMSLException \u4e00 = new NMSLException("\u26c5\u4df8\u4de7\u4dcc\u4dd1\u4dd7\u4df6\u2680\u26e1\u4de7\u4dc7\ua69b\u277c\u4df9\u26eb\u4dfa\u4dde\u4df7\ua64e\u4de4\u275e\u4df1\u4de5\ua693\u47be\u26bc\u4dd6\ua679\u2762\u4dcb\u4dee\u468e\u2627\u3806\u4dd2\u3ae2\u4c98\u4ddf\u4dfc\u4de5\u4de0\u4dc2\u3b25\u263c\u4dea\u2782\u4ddd");

        public void applyOffset(ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                this.applyOffset(method);
            }
        }

        void appendFile(StringBuilder sb) {
            if (this.sourceFilePath != null) {
                sb.append("+ ").append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
                sb.append(this.sourceFilePath).append(SourceMap.NEWLINE);
            } else {
                sb.append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
            }
        }

        public File(int id, int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            this.id = id;
            this.lineOffset = lineOffset;
            this.size = size;
            this.sourceFileName = sourceFileName;
            this.sourceFilePath = sourceFilePath;
        }

        public void applyOffset(MethodNode method) {
            ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iter.next();
                if (!(node instanceof LineNumberNode)) continue;
                ((LineNumberNode)node).line += this.lineOffset - 1;
            }
        }

        public void appendLines(StringBuilder sb) {
            sb.append("1#").append(this.id).append(",").append(this.size).append(":").append(this.lineOffset).append(SourceMap.NEWLINE);
        }

        public File(int id, int lineOffset, int size, String sourceFileName) {
            this(id, lineOffset, size, sourceFileName, null);
        }
    }
}

