/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.commons.ClassRemapper;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.MixinClassWriter;
import pers.XiaoShadiao.NMSLException;

final class InnerClassGenerator
implements IClassGenerator {
    private static final Logger logger;
    private final Map<String, InnerClassInfo> innerClasses;
    private final Map<String, String> innerClassNames = new HashMap<String, String>();
    private static final NMSLException \u4e0d\u591f\u6211\u4eec\u5206\u5566;

    private byte[] generate(InnerClassInfo info) {
        try {
            logger.debug("Generating mapped inner class {} (originally {})", new Object[]{info.getName(), info.getOriginalName()});
            ClassReader cr = new ClassReader(info.getClassBytes());
            MixinClassWriter cw = new MixinClassWriter(cr, 0);
            cr.accept(new InnerClassAdapter((ClassVisitor)cw, info), 8);
            return cw.toByteArray();
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] generate(String name) {
        String ref = name.replace('.', '/');
        InnerClassInfo info = this.innerClasses.get(ref);
        if (info != null) {
            return this.generate(info);
        }
        return null;
    }

    InnerClassGenerator() {
        this.innerClasses = new HashMap<String, InnerClassInfo>();
    }

    private static String getUniqueReference(String originalName, MixinTargetContext context) {
        String name = originalName.substring(originalName.lastIndexOf(36) + 1);
        if (name.matches("^[0-9]+$")) {
            name = "Anonymous";
        }
        return String.format("%s$%s$%s", context.getTargetClassRef(), name, UUID.randomUUID().toString().replace("-", ""));
    }

    static {
        \u4e0d\u591f\u6211\u4eec\u5206\u5566 = new NMSLException("\u46d8\u4918\u262e\u3e1c\u27aa\u4082\u4dfe\u4dfb\u4dc5\u4dd6\u370c\u4dcf\u46dd\u4df4\u275e\u4dc9\u4dcd\u269a\u2776\u4df0\u4dd1\u2708\u4de9\u4dc1\u2790\u2606\u4dd6\u2696\u272f\u4dea\u3552\u3f26");
        logger = LogManager.getLogger((String)"mixin");
    }

    public String registerInnerClass(MixinInfo owner, String originalName, MixinTargetContext context) {
        String id = String.format("%s%s", originalName, context);
        String ref = this.innerClassNames.get(id);
        if (ref == null) {
            ref = InnerClassGenerator.getUniqueReference(originalName, context);
            this.innerClassNames.put(id, ref);
            this.innerClasses.put(ref, new InnerClassInfo(ref, originalName, owner, context));
            logger.debug("Inner class {} in {} on {} gets unique name {}", new Object[]{originalName, owner.getClassRef(), context.getTargetClassRef(), ref});
        }
        return ref;
    }

    static class InnerClassAdapter
    extends ClassRemapper {
        private final InnerClassInfo info;
        private static final NMSLException \u6211\u4eec\u4e58\u7740\u7a7f\u68ad\u5728\u7fc1\u6cd5\u7f57\u65af\u7684\u706b\u7b52 = new NMSLException("\u2778\u274c\u4df1\u4ded\u4dd1\u2724\u276c\u27a9\u4dd2\u2797\u26c9\u4dff\u263c\ua644\u4dfd\u2617\u275f\u47c6\u4de0\u4dfa\ua687\u4dc1\u26e0\u4dc6\u4df1\ua654\u4dc7\u2623\u279f\u3b37\u3889\ua66b\u2617\u275c\ua678\u275b\u4dc1");

        @Override
        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
            AnnotationVisitor av = this.cv.visitAnnotation("Lorg/spongepowered/asm/mixin/transformer/meta/MixinInner;", false);
            av.visit("mixin", this.info.getOwner().toString());
            av.visit("name", this.info.getOriginalName().substring(this.info.getOriginalName().lastIndexOf(47) + 1));
            av.visitEnd();
        }

        public InnerClassAdapter(ClassVisitor cv, InnerClassInfo info) {
            super(327680, cv, info);
            this.info = info;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name.startsWith(this.info.getOriginalName() + "$")) {
                throw new InvalidMixinException((IMixinInfo)this.info.getOwner(), "Found unsupported nested inner class " + name + " in " + this.info.getOriginalName());
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    static class InnerClassInfo
    extends Remapper {
        private final MixinTargetContext target;
        private final String ownerName;
        private final String originalName;
        private final MixinInfo owner;
        private final String targetName;
        private final String name;
        private static final NMSLException \u9010\u706b\u4e4b\u65c5\u5df2\u7ecf\u5f00\u542f\u5f88\u4e45\u5566 = new NMSLException("\ua641\u26a4\u4ddd\u4dee\u2788\u2712\u2776\u4dda\u4df3\u4ddf\u49e0\u4de5\u2676\u4ddf\u264f\u4dc5\u2779\u261b\u4ddf\u3571\u4dc5\u4dfc\u4de1\u272d\u4de8\u4df0\u2722\u27a5\u4dc5\u4de6\u277d\u26ef\u4dd4\u4dc2\u4de9\u4de3\u4de1");

        MixinTargetContext getTarget() {
            return this.target;
        }

        String getName() {
            return this.name;
        }

        MixinInfo getOwner() {
            return this.owner;
        }

        InnerClassInfo(String name, String originalName, MixinInfo owner, MixinTargetContext target) {
            this.name = name;
            this.originalName = originalName;
            this.owner = owner;
            this.ownerName = owner.getClassRef();
            this.target = target;
            this.targetName = target.getTargetClassRef();
        }

        String getOwnerName() {
            return this.ownerName;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String map(String key) {
            if (this.originalName.equals(key)) {
                return this.name;
            }
            if (this.ownerName.equals(key)) {
                return this.targetName;
            }
            return key;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            ClassInfo.Method method;
            if (this.ownerName.equalsIgnoreCase(owner) && (method = this.owner.getClassInfo().findMethod(name, desc, 10)) != null) {
                return method.getName();
            }
            return super.mapMethodName(owner, name, desc);
        }

        byte[] getClassBytes() throws ClassNotFoundException, IOException {
            return MixinService.getService().getBytecodeProvider().getClassBytes(this.originalName, true);
        }

        String getTargetName() {
            return this.targetName;
        }

        String getOriginalName() {
            return this.originalName;
        }
    }
}

