/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.Map;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidInterfaceMixinException;
import pers.XiaoShadiao.NMSLException;

class MixinApplicatorInterface
extends MixinApplicatorStandard {
    private static final NMSLException \u4e8c = new NMSLException("\u4df1\u278c\u4de5\u4b04\ua66f\u4dd2\u3e5e\u44c4\u4dc3\u4dd2\ua67f\u2710\u4dd3\u2673\u4159\u270f\u3eb7\ua646\u4df0\u4dd0\u2636\u4df9\u3ffd\u2677\u4dfa\u3a56\u4dc4\ua668\u26f5\u4de8\u2738\ua65d\ua69b");

    @Override
    protected void applyInitialisers(MixinTargetContext mixin) {
    }

    MixinApplicatorInterface(TargetClassContext context) {
        super(context);
    }

    @Override
    protected void prepareInjections(MixinTargetContext mixin) {
        for (MethodNode method : this.targetClass.methods) {
            try {
                InjectionInfo injectInfo = InjectionInfo.parse(mixin, method);
                if (injectInfo == null) continue;
                throw new InvalidInterfaceMixinException((IMixinContext)mixin, injectInfo + " is not supported on interface mixin method " + method.name);
            }
            catch (InvalidInjectionException ex) {
                String description = ex.getInjectionInfo() != null ? ex.getInjectionInfo().toString() : "Injection";
                throw new InvalidInterfaceMixinException((IMixinContext)mixin, description + " is not supported in interface mixin");
            }
        }
    }

    @Override
    protected void applyInterfaces(MixinTargetContext mixin) {
        for (String interfaceName : mixin.getInterfaces()) {
            if (this.targetClass.name.equals(interfaceName) || this.targetClass.interfaces.contains(interfaceName)) continue;
            this.targetClass.interfaces.add(interfaceName);
            mixin.getTargetClassInfo().addInterface(interfaceName);
        }
    }

    @Override
    protected void applyFields(MixinTargetContext mixin) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixin.getShadowFields()) {
            FieldNode shadow = entry.getKey();
            this.logger.error("Ignoring redundant @Shadow field {}:{} in {}", new Object[]{shadow.name, shadow.desc, mixin});
        }
        this.mergeNewFields(mixin);
    }

    @Override
    protected void applyInjections(MixinTargetContext mixin) {
    }
}

