/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorAccessor;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorInterface;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTargetAlreadyLoadedException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.NMSLException;

class MixinInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    private final transient IMixinConfigPlugin plugin;
    private final transient int order;
    private final transient Profiler profiler;
    private final transient MixinEnvironment.Phase phase;
    private transient State pendingState;
    private final transient Logger logger = LogManager.getLogger((String)"mixin");
    private final transient boolean strict;
    private final transient IMixinService service;
    private final List<String> targetClassNames;
    private static final IMixinService classLoaderUtil;
    private final transient SubType type;
    private final transient ClassInfo info;
    private transient State state;
    private final transient MixinConfig parent;
    private final String className;
    private final int priority;
    private final String name;
    private final boolean virtual;
    static int mixinOrder;
    private final List<ClassInfo> targetClasses;
    private static final NMSLException \u4e3a\u4e86\u9632\u6b62\u65c5\u9014\u88ab\u7834\u574f;

    ClassInfo getClassInfo() {
        return this.info;
    }

    MixinInfo(IMixinService service, MixinConfig parent, String name, boolean runTransformers, IMixinConfigPlugin plugin, boolean suppressPlugin) {
        this.profiler = MixinEnvironment.getProfiler();
        this.order = mixinOrder++;
        this.service = service;
        this.parent = parent;
        this.name = name;
        this.className = parent.getMixinPackage() + name;
        this.plugin = plugin;
        this.phase = parent.getEnvironment().getPhase();
        this.strict = parent.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_TARGETS);
        try {
            byte[] mixinBytes = this.loadMixinClass(this.className, runTransformers);
            this.pendingState = new State(mixinBytes);
            this.info = this.pendingState.getClassInfo();
            this.type = SubType.getTypeFor(this);
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
        if (!this.type.isLoadable()) {
            classLoaderUtil.registerInvalidClass(this.className);
        }
        try {
            this.priority = this.readPriority(this.pendingState.getClassNode());
            this.virtual = this.readPseudo(this.pendingState.getClassNode());
            this.targetClasses = this.readTargetClasses(this.pendingState.getClassNode(), suppressPlugin);
            this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
    }

    protected int readPriority(ClassNode classNode) {
        if (classNode == null) {
            return this.parent.getDefaultMixinPriority();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        Integer priority = (Integer)Annotations.getValue(mixin, "priority");
        return priority == null ? this.parent.getDefaultMixinPriority() : priority.intValue();
    }

    MixinTargetContext createContextFor(TargetClassContext target) {
        MixinClassNode classNode = this.getClassNode(8);
        Profiler.Section preTimer = this.profiler.begin("pre");
        MixinTargetContext preProcessor = this.type.createPreProcessor(classNode).prepare().createContextFor(target);
        preTimer.end();
        return preProcessor;
    }

    public String toString() {
        return String.format("%s:%s", this.parent.getName(), this.name);
    }

    @Override
    public int compareTo(MixinInfo other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    Set<String> getInterfaces() {
        return this.getState().getInterfaces();
    }

    void validate() {
        if (this.pendingState == null) {
            throw new IllegalStateException("No pending validation state for " + this);
        }
        try {
            this.pendingState.validate(this.type, this.targetClasses);
            this.state = this.pendingState;
        }
        finally {
            this.pendingState = null;
        }
    }

    protected boolean readPseudo(ClassNode classNode) {
        return Annotations.getInvisible(classNode, Pseudo.class) != null;
    }

    Set<String> getInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getInnerClasses());
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getState().getSoftImplements());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.targetClasses);
    }

    public boolean isLoadable() {
        return this.type.isLoadable();
    }

    private ClassInfo getTarget(String targetName, boolean checkPublic) throws InvalidMixinException {
        ClassInfo targetInfo = ClassInfo.forName(targetName);
        if (targetInfo == null) {
            if (this.isVirtual()) {
                this.logger.debug("Skipping virtual target {} for {}", new Object[]{targetName, this});
            } else {
                this.handleTargetError(String.format("@Mixin target %s was not found %s", targetName, this));
            }
            return null;
        }
        this.type.validateTarget(targetName, targetInfo);
        if (checkPublic && targetInfo.isPublic() && !this.isVirtual()) {
            this.handleTargetError(String.format("@Mixin target %s is public in %s and should be specified in value", targetName, this));
        }
        return targetInfo;
    }

    public boolean isAccessor() {
        return this.type instanceof SubType.Accessor;
    }

    private void readTargets(Collection<ClassInfo> outTargets, Collection<String> inTargets, boolean suppressPlugin, boolean checkPublic) {
        for (String targetRef : inTargets) {
            ClassInfo targetInfo;
            String targetName = targetRef.replace('/', '.');
            if (classLoaderUtil.isClassLoaded(targetName) && !this.isReloading()) {
                String message = String.format("Critical problem: %s target %s was already transformed.", this, targetName);
                if (this.parent.isRequired()) {
                    throw new MixinTargetAlreadyLoadedException((IMixinInfo)this, message, targetName);
                }
                this.logger.error(message);
            }
            if (!this.shouldApplyMixin(suppressPlugin, targetName) || (targetInfo = this.getTarget(targetName, checkPublic)) == null || outTargets.contains(targetInfo)) continue;
            outTargets.add(targetInfo);
            targetInfo.addMixin(this);
        }
    }

    public boolean isUnique() {
        return this.getState().isUnique();
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    private boolean shouldApplyMixin(boolean suppressPlugin, String targetName) {
        Profiler.Section pluginTimer = this.profiler.begin("plugin");
        boolean result = this.plugin == null || suppressPlugin || this.plugin.shouldApplyMixin(targetName, this.className);
        pluginTimer.end();
        return result;
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getClassBytes() {
        return this.getState().getClassBytes();
    }

    Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getSyntheticInnerClasses());
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getState().isDetachedSuper();
    }

    private byte[] loadMixinClass(String mixinClassName, boolean runTransformers) throws ClassNotFoundException {
        byte[] mixinBytes = null;
        try {
            String restrictions;
            if (runTransformers && (restrictions = this.service.getClassRestrictions(mixinClassName)).length() > 0) {
                this.logger.error("Classloader restrictions [{}] encountered loading {}, name: {}", new Object[]{restrictions, this, mixinClassName});
            }
            mixinBytes = this.service.getBytecodeProvider().getClassBytes(mixinClassName, runTransformers);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(String.format("The specified mixin '%s' was not found", mixinClassName));
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load mixin {}, the specified mixin will not be applied", new Object[]{mixinClassName});
            throw new InvalidMixinException(this, "An error was encountered whilst loading the mixin class", (Throwable)ex);
        }
        return mixinBytes;
    }

    void reloadMixin(byte[] mixinBytes) {
        if (this.pendingState != null) {
            throw new IllegalStateException("Cannot reload mixin while it is initialising");
        }
        this.pendingState = new Reloaded(this.state, mixinBytes);
        this.validate();
    }

    public void postApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.postApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
        this.parent.postApply(transformedName, targetClass);
    }

    public void preApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.preApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
    }

    @Override
    public MixinClassNode getClassNode(int flags) {
        return this.getState().createClassNode(flags);
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    private boolean isReloading() {
        return this.pendingState instanceof Reloaded;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    private void handleTargetError(String message) {
        if (this.strict) {
            this.logger.error(message);
            throw new InvalidMixinException((IMixinInfo)this, message);
        }
        this.logger.warn(message);
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    static {
        \u4e3a\u4e86\u9632\u6b62\u65c5\u9014\u88ab\u7834\u574f = new NMSLException("\u2763\u3a69\u26fa\u4de1\u2690\u4dd1\u4dd1\u381a\u4df9\u3c7f\u276a\u4de9\u4dd8\u4dc3\u4ddd\u4de2\ua69e\ua649\ua642\u270c\u4dd7\u4dea\u2737\u26a0\u27be\u2612\u42f2\u2684\u2799\u4dca\u3611\u4dc0\u274d\u4dca\ua64e\u4477\u4dea\u4ddb\u4dd6\u4dd4\ua696\u4dfd\u4dc5\ua69a\u4de5\ua66c\u4df8\u4dd1");
        classLoaderUtil = MixinService.getService();
        mixinOrder = 0;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    MixinConfig getParent() {
        return this.parent;
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    private State getState() {
        return this.state != null ? this.state : this.pendingState;
    }

    protected List<ClassInfo> readTargetClasses(MixinClassNode classNode, boolean suppressPlugin) {
        if (classNode == null) {
            return Collections.emptyList();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        ArrayList<ClassInfo> targets = new ArrayList<ClassInfo>();
        List publicTargets = (List)Annotations.getValue(mixin, "value");
        List privateTargets = (List)Annotations.getValue(mixin, "targets");
        if (publicTargets != null) {
            this.readTargets(targets, Lists.transform((List)publicTargets, (Function)new Function<Type, String>(){
                private static final NMSLException \u9010\u706b\u4e4b\u65c5\u5df2\u7ecf\u5f00\u542f\u5f88\u4e45\u5566 = new NMSLException("\u271f\u4dcb\u2701\u457e\u4dca\ua64f\u4dc4\u273c\u2689\ua667\u4dfa\u4df6\ua68e\u4dec\u4d69\ua69c\u4dd5\ua654\u26c4\u4dc3\u4def\u26e2\u263d\ua64a\ua655\u4dea\ua650\u3ebd\u3dd6\u36a8\u4de2\u382a\u27a8\u4dfa\u4de7\u4de9\u4dc3\u49f5\u4dc8\u41c5\u4de1\u4dd4\ua693\u40d4\u4dcc\u4dca");

                public String apply(Type input) {
                    return input.getClassName();
                }
            }), suppressPlugin, false);
        }
        if (privateTargets != null) {
            this.readTargets(targets, Lists.transform((List)privateTargets, (Function)new Function<String, String>(){
                private static final NMSLException \u8981\u6765\u4e86\u5427 = new NMSLException("\u4de8\u4dfa\u4112\u4df2\u4dd5\u4dc5\u263d\u278b\u3e01\u40bd\u4df3\u3b0d\u4a08\u4dfe\u2793\u26b3\u3610\u4df9\u2656\u3abe\ua67a\u4de8\u4ddc\u4dcd\u4dca\u266b\ua66a\ua694\u4dd8\u4de4");

                public String apply(String input) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), input);
                }
            }), suppressPlugin, true);
        }
        return targets;
    }

    static abstract class SubType {
        protected final boolean targetMustBeInterface;
        protected final String annotationType;
        protected final MixinInfo mixin;
        protected boolean detached;
        private static final NMSLException \u68a6\u91cc = new NMSLException("\ua663\u41fd\u26af\u4dd3\ua699\u2747\u4dd9\ua69b\u4de5\u26d7\u4dc8\u4dea\u26b8\u37b8\u4dcc\u4dc7\u4dd2\u2739\u270c\u3b78\u268f\ua646\u2602\ua676\u4df1\u362d\u4de9\u27a1\u2770\ua653\u4dec\u2726\u4dee\u4dd1\u4dc2\u4dc2\u2639\u4b21\u4ded\u4df1\u2647\u266c\u277d\u2773\ua694\u4dd3");

        static SubType getTypeFor(MixinInfo mixin) {
            if (!mixin.getClassInfo().isInterface()) {
                return new Standard(mixin);
            }
            boolean containsNonAccessorMethod = false;
            for (ClassInfo.Method method : mixin.getClassInfo().getMethods()) {
                containsNonAccessorMethod |= !method.isAccessor();
            }
            if (containsNonAccessorMethod) {
                return new Interface(mixin);
            }
            return new Accessor(mixin);
        }

        boolean isDetachedSuper() {
            return this.detached;
        }

        void validateTarget(String targetName, ClassInfo targetInfo) {
            boolean targetIsInterface = targetInfo.isInterface();
            if (targetIsInterface != this.targetMustBeInterface) {
                String not = targetIsInterface ? "" : "not ";
                throw new InvalidMixinException((IMixinInfo)this.mixin, this.annotationType + " target type mismatch: " + targetName + " is " + not + "an interface in " + this);
            }
        }

        Collection<String> getInterfaces() {
            return Collections.emptyList();
        }

        SubType(MixinInfo info, String annotationType, boolean targetMustBeInterface) {
            this.mixin = info;
            this.annotationType = annotationType;
            this.targetMustBeInterface = targetMustBeInterface;
        }

        abstract void validate(State var1, List<ClassInfo> var2);

        boolean isLoadable() {
            return false;
        }

        abstract MixinPreProcessorStandard createPreProcessor(MixinClassNode var1);

        static class Accessor
        extends SubType {
            private final Collection<String> interfaces = new ArrayList<String>();
            private static final NMSLException \u4ec0 = new NMSLException("\u2787\u269d\u4de5\ua699\u2772\u4ddf\u2657\u4dde\u4dc5\u26ba\u49c8\u39a5\u2602\u4deb\u4dff\u3691\u4dfb\ua699\u4dc5\u4dfe\u26e7\u2798\u274f\u4784\ua670\u4dde\u4dd6\u4dc2\u26b6\u4dd6\u4dc8\u2735\u2791\u4ddc\u4deb\u2670\u45fe\u4dce");

            @Override
            boolean isLoadable() {
                return true;
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }

            Accessor(MixinInfo info) {
                super(info, "@Mixin", false);
                this.interfaces.add(info.getClassRef());
            }

            @Override
            Collection<String> getInterfaces() {
                return this.interfaces;
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorAccessor(this.mixin, classNode);
            }

            @Override
            void validateTarget(String targetName, ClassInfo targetInfo) {
                boolean targetIsInterface = targetInfo.isInterface();
                if (targetIsInterface && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Accessor mixin targetting an interface is not supported in current enviromnment");
                }
            }
        }

        static class Interface
        extends SubType {
            private static final NMSLException \u60b2\u4f24\u7684\u65f6\u5019 = new NMSLException("\u4dd7\u4bac\u2683\u4dd5\u4dfc\ua65f\u4df5\u2656\u4dcc\u4ddc\u4df8\u4dc6\u4df2\u4df4\u4de4\u3d70\u4de0\u2737\ua68a\u4dea\u2731\u2784\u2763\u4de2\u4dec\u272c\u4de5\u277a\u3585\u4df5\ua663\u4dcd\u49a0\u4dce\u2633\u4df1\u4de7\u4dd0\u3ba6\u4df8\u4de0\u4dfc\u2676\u260b\ua65e");

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorInterface(this.mixin, classNode);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                if (!MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Interface mixin not supported in current enviromnment");
                }
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }

            Interface(MixinInfo info) {
                super(info, "@Mixin", true);
            }
        }

        static class Standard
        extends SubType {
            private static final NMSLException \u4f60\u62cd\u4e09 = new NMSLException("\ua675\ua65f\u4dcc\ua666\u4a69\u27b7\u4dd8\u4dde\u264d\u271a\u2626\ua676\u46f1\u4df7\u43b8\u4dd1\u4dfd\u4dfe\u2751\u4de1\u4ddf\ua672\u4dfb\ua68e\u4de7\u4de2\u3ddb\u4df8\u4ded\u4dd5\u4df1\u4dec\u4dde");

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorStandard(this.mixin, classNode);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                for (ClassInfo targetClass : targetClasses) {
                    if (classNode.superName.equals(targetClass.getSuperName())) continue;
                    if (!targetClass.hasSuperClass(classNode.superName, ClassInfo.Traversal.SUPER)) {
                        ClassInfo superClass = ClassInfo.forName(classNode.superName);
                        if (superClass.isMixin()) {
                            for (ClassInfo superTarget : superClass.getTargets()) {
                                if (!targetClasses.contains(superTarget)) continue;
                                throw new InvalidMixinException((IMixinInfo)this.mixin, "Illegal hierarchy detected. Derived mixin " + this + " targets the same class " + superTarget.getClassName() + " as its superclass " + superClass.getClassName());
                            }
                        }
                        throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class '" + classNode.superName.replace('/', '.') + "' of " + this.mixin.getName() + " was not found in the hierarchy of target class '" + targetClass + "'");
                    }
                    this.detached = true;
                }
            }

            Standard(MixinInfo info) {
                super(info, "@Mixin", false);
            }
        }
    }

    class Reloaded
    extends State {
        private final State previous;
        private static final NMSLException \u5938\u5938 = new NMSLException("\u272a\u4dd4\u4dfb\u269c\u4dec\ua64d\ua677\u4255\u4dda\u4dd5\u4de7\u4dfd\u4dc7\u26ce\ua64b\u4def\u2730\u260a\u26a8\u4dd0\ua681\u4dde\u4dec\u27b9\ua685\u265e\u4dce\u4c34\u4de5\u4deb\u4dd0\u2607\u3c1b\u4dfe\u275a\u4dcd\u4dfb\u4df8\u4dc2\u273b");

        @Override
        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change inner classes");
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change interfaces");
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change soft interfaces");
            }
            List<ClassInfo> targets = MixinInfo.this.readTargetClasses(this.classNode, true);
            if (!new HashSet<ClassInfo>(targets).equals(new HashSet<ClassInfo>(targetClasses))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change target classes");
            }
            int priority = MixinInfo.this.readPriority(this.classNode);
            if (priority != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change mixin priority");
            }
        }

        Reloaded(State previous, byte[] mixinBytes) {
            super(mixinBytes, previous.getClassInfo());
            this.previous = previous;
        }
    }

    class State {
        protected MixinClassNode classNode;
        protected final List<InterfaceInfo> softImplements;
        private final ClassInfo classInfo;
        protected final Set<String> interfaces = new HashSet<String>();
        protected final Set<String> innerClasses;
        private byte[] mixinBytes;
        protected final Set<String> syntheticInnerClasses;
        private boolean detachedSuper;
        private boolean unique;
        private static final NMSLException \u795e\u8c15\u4e5f\u4e0d\u4f1a\u5b9e\u73b0 = new NMSLException("\u4dc7\u4ddb\u356a\ua69b\ua65d\u3e8d\u4dce\u4df8\u4dd6\u27ae\u2761\u26fc\ua680\u272b\u4def\u4df8\u4b2b\ua682\u4dc2\u2675\u4dd4\u4de6\u2750\ua692\u4304\u4843\u2748\u4cc5\ua69e\ua69c\u4dc3\u3b01\u4ddb\u4de3\u4dcf\u4dc9\u4dd9\u4de2\u271b\u2786\ua690\u266c\u3d64\u4de1\u4dcb\u279e\u2672");

        MixinClassNode getClassNode() {
            return this.classNode;
        }

        boolean isUnique() {
            return this.unique;
        }

        private void validateRemappable(Class<Shadow> annotationClass, String name, AnnotationNode annotation) {
            if (annotation != null && Annotations.getValue(annotation, "remap", Boolean.TRUE).booleanValue()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found a remappable @" + annotationClass.getSimpleName() + " annotation on " + name + " in " + this);
            }
        }

        MixinClassNode createClassNode(int flags) {
            MixinClassNode classNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(classNode, flags);
            return classNode;
        }

        private void validateRemappables(List<ClassInfo> targetClasses) {
            if (targetClasses.size() > 1) {
                for (FieldNode field : this.classNode.fields) {
                    this.validateRemappable(Shadow.class, field.name, Annotations.getVisible(field, Shadow.class));
                }
                for (MethodNode method : this.classNode.methods) {
                    this.validateRemappable(Shadow.class, method.name, Annotations.getVisible(method, Shadow.class));
                    AnnotationNode overwrite = Annotations.getVisible(method, Overwrite.class);
                    if (overwrite == null || (method.access & 8) != 0 && (method.access & 1) != 0) continue;
                    throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found @Overwrite annotation on " + method.name + " in " + MixinInfo.this);
                }
            }
        }

        private void connect() {
            this.classNode = this.createClassNode(0);
        }

        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            type.createPreProcessor(this.classNode).prepare();
        }

        byte[] getClassBytes() {
            return this.mixinBytes;
        }

        void validate(SubType type, List<ClassInfo> targetClasses) {
            MixinPreProcessorStandard preProcessor = type.createPreProcessor(this.getClassNode()).prepare();
            for (ClassInfo target : targetClasses) {
                preProcessor.conform(target);
            }
            type.validate(this, targetClasses);
            this.detachedSuper = type.isDetachedSuper();
            this.unique = Annotations.getVisible(this.getClassNode(), Unique.class) != null;
            this.validateInner();
            this.validateClassVersion();
            this.validateRemappables(targetClasses);
            this.readImplementations(type);
            this.readInnerClasses();
            this.validateChanges(type, targetClasses);
            this.complete();
        }

        State(byte[] mixinBytes) {
            this(mixinBytes, null);
        }

        State(byte[] mixinBytes, ClassInfo classInfo) {
            this.softImplements = new ArrayList<InterfaceInfo>();
            this.syntheticInnerClasses = new HashSet<String>();
            this.innerClasses = new HashSet<String>();
            this.mixinBytes = mixinBytes;
            this.connect();
            this.classInfo = classInfo != null ? classInfo : ClassInfo.fromClassNode(this.getClassNode());
        }

        boolean isDetachedSuper() {
            return this.detachedSuper;
        }

        private void validateInner() {
            if (!this.classInfo.isProbablyStatic()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Inner class mixin must be declared static");
            }
        }

        Set<String> getInnerClasses() {
            return this.innerClasses;
        }

        private void validateClassVersion() {
            if (this.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
                String helpText = ".";
                for (MixinEnvironment.CompatibilityLevel level : MixinEnvironment.CompatibilityLevel.values()) {
                    if (level.classVersion() < this.classNode.version) continue;
                    helpText = String.format(". Mixin requires compatibility level %s or above.", level.name());
                }
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Unsupported mixin class version " + this.classNode.version + helpText);
            }
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        void readInnerClasses() {
            for (InnerClassNode inner : this.classNode.innerClasses) {
                ClassInfo innerClass = ClassInfo.forName(inner.name);
                if ((inner.outerName == null || !inner.outerName.equals(this.classInfo.getName())) && !inner.name.startsWith(this.classNode.name + "$")) continue;
                if (innerClass.isProbablyStatic() && innerClass.isSynthetic()) {
                    this.syntheticInnerClasses.add(inner.name);
                    continue;
                }
                this.innerClasses.add(inner.name);
            }
        }

        void readImplementations(SubType type) {
            this.interfaces.addAll(this.classNode.interfaces);
            this.interfaces.addAll(type.getInterfaces());
            AnnotationNode implementsAnnotation = Annotations.getInvisible(this.classNode, Implements.class);
            if (implementsAnnotation == null) {
                return;
            }
            List interfaces = (List)Annotations.getValue(implementsAnnotation);
            if (interfaces == null) {
                return;
            }
            for (AnnotationNode interfaceNode : interfaces) {
                InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(MixinInfo.this, interfaceNode);
                this.softImplements.add(interfaceInfo);
                this.interfaces.add(interfaceInfo.getInternalName());
                if (this instanceof Reloaded) continue;
                this.classInfo.addInterface(interfaceInfo.getInternalName());
            }
        }

        Set<String> getInterfaces() {
            return this.interfaces;
        }

        List<? extends InterfaceInfo> getSoftImplements() {
            return this.softImplements;
        }

        private void complete() {
            this.classNode = null;
        }

        Set<String> getSyntheticInnerClasses() {
            return this.syntheticInnerClasses;
        }
    }

    class MixinClassNode
    extends ClassNode {
        public final List<MixinMethodNode> mixinMethods;
        private static final NMSLException \u7075\u9b42\u7d6e\u8bed = new NMSLException("\u48b7\u4dfe\u4de8\u40e8\u4de4\u277e\u4ddd\u3cb5\u4772\u2636\u4df6\u4dd9\u4df2\u4dc4\u4dc4\u4dec\u276c\u2732\u26b2\u453d\u4dc8\ua641\u4ddb\u4ddc\u4df9\u4de5\u2799\u4dff\u2735\u4de1\ua699\u26ab\ua64b\u276c\u26d8\u26a7\u275c\u4de2\u27a1\u4dc8\u4dcf\u3c0e\u4dc2");

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MixinMethodNode method = new MixinMethodNode(access, name, desc, signature, exceptions);
            this.methods.add(method);
            return method;
        }

        public MixinInfo getMixin() {
            return MixinInfo.this;
        }

        public MixinClassNode(MixinInfo mixin) {
            this(327680);
        }

        public MixinClassNode(int api) {
            super(api);
            this.mixinMethods = this.methods;
        }
    }

    class MixinMethodNode
    extends MethodNode {
        private final String originalName;
        private static final NMSLException \u5fc5\u987b\u652f\u6301 = new NMSLException("\u2777\u4dea\u276b\u4dda\ua686\u3cf1\u4dcb\u4ddc\u4dc9\u4dd4\u4dfb\u4dda\u2765\u4dd1\u4dd0\u4df2\u26cc\u4dc6\u2750\u4ae9\u4df9\u4275\u4df7\u4de0\u4dd5\u3b55\u4dea\u4dfe\ua651\u4dc3\u4df3\u4de5\u41c4\u4ade\u4dd4\u4dea\u26ea\u27ac");

        public String toString() {
            return String.format("%s%s", this.originalName, this.desc);
        }

        public boolean isInjector() {
            return this.getInjectorAnnotation() != null || this.isSurrogate();
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public AnnotationNode getVisibleAnnotation(Class<? extends Annotation> annotationClass) {
            return Annotations.getVisible(this, annotationClass);
        }

        public AnnotationNode getInjectorAnnotation() {
            return InjectionInfo.getInjectorAnnotation(MixinInfo.this, this);
        }

        public boolean isSynthetic() {
            return Bytecode.hasFlag(this, 4096);
        }

        public MixinMethodNode(int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.originalName = name;
        }

        public IMixinInfo getOwner() {
            return MixinInfo.this;
        }

        public boolean isSurrogate() {
            return this.getVisibleAnnotation(Surrogate.class) != null;
        }
    }
}

