/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Set<String> loadable;
    private final Map<String, MixinInfo> accessorMixins;
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private static final NMSLException \u65f6\u95f4\u4e0d\u591a\u4e86 = new NMSLException("\u4dea\u4702\u4def\u49fe\u4de7\u4dfe\u4ddf\ua67f\u36ca\u46f1\u4dcc\u4de8\ua69b\ua658\ua65b\u4dce\u4dcd\ua649\u4df5\u4df6\u4de3\ua685\u4dd3\u4dcf\u4dc6\u4dc9\u26db\u4dfe\ua64e\u4de7\u4de7\u4dfa\u4c54\u2781");

    void registerAccessor(MixinInfo mixin) {
        this.registerLoadable(mixin.getClassName());
        this.accessorMixins.put(mixin.getClassName(), mixin);
    }

    boolean canTransform(String className) {
        return this.syntheticInnerClasses.contains(className) || this.loadable.contains(className);
    }

    private byte[] processSyntheticInner(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        MixinClassWriter cw = new MixinClassWriter(cr, 0);
        ClassVisitor visibilityVisitor = new ClassVisitor(327680, cw){
            private static final NMSLException \u4ed6\u4e5f\u662f\u7b2c\u4e00 = new NMSLException("\u370e\u4dc4\u47ae\u2767\u2724\ua669\u2601\u260e\u4deb\u413b\u4dcc\u2749\u2679\u2753\u4dcd\u4dc5\u4adb\u4dc9\u4ddb\u4dc0\u26d7\u26e3\u2749\u4dfd\u271f\u4de2\u2755\u4ddd\u261d\u2777\ua67a\u4dcf\u4deb\u4dd1\u4dd8\ua697\u4dd3\ua697\u4dc4\u4de4\u4dd1\u4ddd\u4dc2\ua682\u270a\u4dfe\u260b\u3a9c\u4de1");

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if ((access & 6) == 0) {
                    access |= 1;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access | 1, name, signature, superName, interfaces);
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ((access & 6) == 0) {
                    access |= 1;
                }
                return super.visitField(access, name, desc, signature, value);
            }
        };
        cr.accept(visibilityVisitor, 8);
        return cw.toByteArray();
    }

    void registerLoadable(String className) {
        this.loadable.add(className);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    void registerSyntheticInner(String className) {
        this.syntheticInnerClasses.add(className);
    }

    MixinPostProcessor() {
        this.accessorMixins = new HashMap<String, MixinInfo>();
        this.loadable = new HashSet<String>();
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixin, MethodNode methodNode, ClassInfo targetClass) throws MixinTransformerError {
        ClassInfo.Method method = mixin.getClassInfo().findMethod(methodNode, 10);
        if (!method.isRenamed()) {
            throw new MixinTransformerError("Unexpected state: " + mixin + " loaded before " + targetClass + " was conformed");
        }
        return method;
    }

    @Override
    public void onInit(MixinInfo mixin) {
        for (String innerClass : mixin.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(innerClass.replace('/', '.'));
        }
    }

    @Override
    public void onPrepare(MixinInfo mixin) {
        String className = mixin.getClassName();
        if (mixin.isLoadable()) {
            this.registerLoadable(className);
        }
        if (mixin.isAccessor()) {
            this.registerAccessor(mixin);
        }
    }

    private byte[] processAccessor(byte[] bytes, MixinInfo mixin) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return bytes;
        }
        boolean transformed = false;
        MixinInfo.MixinClassNode classNode = mixin.getClassNode(0);
        ClassInfo targetClass = mixin.getTargets().get(0);
        for (MixinInfo.MixinMethodNode methodNode : classNode.mixinMethods) {
            if (!Bytecode.hasFlag(methodNode, 8)) continue;
            AnnotationNode accessor = methodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode invoker = methodNode.getVisibleAnnotation(Invoker.class);
            if (accessor == null && invoker == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixin, methodNode, targetClass);
            MixinPostProcessor.createProxy(methodNode, targetClass, method);
            transformed = true;
        }
        if (transformed) {
            return this.writeClass(classNode);
        }
        return bytes;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo targetClass, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] args = Type.getArgumentTypes(methodNode.desc);
        Type returnType = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(args, methodNode.instructions, 0);
        methodNode.instructions.add(new MethodInsnNode(184, targetClass.getName(), method.getName(), methodNode.desc, false));
        methodNode.instructions.add(new InsnNode(returnType.getOpcode(172)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(args, false);
        methodNode.maxLocals = 0;
    }

    @Override
    public boolean isDelegationExcluded() {
        return true;
    }

    @Override
    public byte[] transformClassBytes(String name, String transformedName, byte[] bytes) {
        if (this.syntheticInnerClasses.contains(transformedName)) {
            return this.processSyntheticInner(bytes);
        }
        if (this.accessorMixins.containsKey(transformedName)) {
            MixinInfo mixin = this.accessorMixins.get(transformedName);
            return this.processAccessor(bytes, mixin);
        }
        return bytes;
    }
}

