/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompiler
extends IFernflowerLogger
implements IResultSaver,
IDecompiler {
    private final File outputPath;
    private final Map<String, Object> options = ImmutableMap.builder().put((Object)"din", (Object)"0").put((Object)"rbr", (Object)"0").put((Object)"dgs", (Object)"1").put((Object)"asc", (Object)"1").put((Object)"den", (Object)"1").put((Object)"hdc", (Object)"1").put((Object)"ind", (Object)"    ").build();
    private static final Level[] SEVERITY_LEVELS;
    protected final Logger logger = LogManager.getLogger((String)"fernflower");
    private static final NMSLException \u8d77\u98de\u54af;

    @Override
    public void decompile(File file) {
        try {
            Fernflower fernflower = new Fernflower(new IBytecodeProvider(){
                private byte[] byteCode;
                private static final NMSLException \u6211\u4eec\u559c\u6b22\u4f60 = new NMSLException("\u4de4\u27bd\u27b1\u4de1\ua692\u4dd2\u4dfc\u4dd7\u4df7\ua67e\u26bb\u4de8\u4dd9\u4df2\ua68c\u383a\ua657\u263e\ua654\u4775\u2688\u4dc0\u430b\u4df9\ua66f\u4942\ua64c\u4dcd\u4de2\u2752\u276b\ua656\u2724\u4dd3\u4dde\u4de0\u2741\u2780\u3437\u35fe\u4188\u4440\u4df9");

                public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                    if (this.byteCode == null) {
                        this.byteCode = InterpreterUtil.getBytes((File)new File(externalPath));
                    }
                    return this.byteCode;
                }
            }, (IResultSaver)this, this.options, (IFernflowerLogger)this);
            fernflower.getStructContext().addSpace(file, true);
            fernflower.decompileContext();
        }
        catch (Throwable ex) {
            this.logger.warn("Decompilation error while processing {}", new Object[]{file.getName()});
        }
    }

    public void writeMessage(String message, Throwable t) {
        this.logger.warn("{} {}: {}", new Object[]{message, t.getClass().getSimpleName(), t.getMessage()});
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message, t);
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message);
    }

    public void startReadingClass(String className) {
        this.logger.info("Decompiling {}", new Object[]{className});
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        File file = new File(this.outputPath, qualifiedName + ".java");
        file.getParentFile().mkdirs();
        try {
            this.logger.info("Writing {}", new Object[]{file.getAbsolutePath()});
            Files.write((CharSequence)content, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            this.writeMessage("Cannot write source file " + file, ex);
        }
    }

    public void closeArchive(String path, String archiveName) {
    }

    public void saveFolder(String path) {
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    static {
        \u8d77\u98de\u54af = new NMSLException("\u4dca\u4de1\u4de2\u4df0\u2633\u27a1\u4dca\u265f\u4dc6\u4dd1\u4dcc\u3928\u2729\u456c\u4de9\u4dcb\u270c\ua65e\u422c\u3928\u4dd3\ua698\u4dd7\u4def\u4dec\u4125\u26ec\ua682\u4c07\u262b\u44a4\u4de0\u4dd6\u4df3\ua675\u4df4\u4dcd\u42cb\u4de1\u2662\u3986\u4dcb");
        SEVERITY_LEVELS = new Level[]{Level.TRACE, Level.INFO, Level.WARN, Level.ERROR};
    }

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }

    public RuntimeDecompiler(File outputPath) {
        this.outputPath = outputPath;
        if (this.outputPath.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputPath);
            }
            catch (IOException ex) {
                this.logger.warn("Error cleaning output directory: {}", new Object[]{ex.getMessage()});
            }
        }
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
    }
}

