/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompilerAsync
extends RuntimeDecompiler
implements Runnable,
Thread.UncaughtExceptionHandler {
    private boolean run = true;
    private final Thread thread;
    private final BlockingQueue<File> queue = new LinkedBlockingQueue<File>();
    private static final NMSLException \u6211\u4eec\u52a0\u5feb\u811a\u6b65\u5427 = new NMSLException("\u4df9\ua674\u4de0\u4dee\u4deb\u4dcb\u4dfe\u4df7\u2760\ua68b\u4de4\u2717\u2758\ua660\u4de5\u3faf\u2715\u2745\u4def\u4dce\u4267\u2791\u26c5\u40be\u4dec\u4dff\u4376\u4dfd\u4de1\u4ded\u4de0\u2742\u45f5\ua64e\u277b\ua655");

    @Override
    public void decompile(File file) {
        if (this.run) {
            this.queue.offer(file);
        } else {
            super.decompile(file);
        }
    }

    private void flush() {
        File file;
        this.run = false;
        while ((file = (File)this.queue.poll()) != null) {
            this.decompile(file);
        }
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                File file = this.queue.take();
                super.decompile(file);
            }
            catch (InterruptedException ex) {
                this.run = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.logger.error("Async decompiler encountered an error and will terminate. Further decompile requests will be handled synchronously. {} {}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        this.flush();
    }

    public RuntimeDecompilerAsync(File outputPath) {
        super(outputPath);
        this.thread = new Thread((Runnable)this, "Decompiler thread");
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.setUncaughtExceptionHandler(this);
        this.thread.start();
    }
}

