/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import pers.XiaoShadiao.NMSLException;

public final class Extensions {
    private final MixinTransformer transformer;
    private final List<IClassGenerator> generatorsView;
    private final List<IClassGenerator> generators;
    private final List<IExtension> extensions = new ArrayList<IExtension>();
    private List<IExtension> activeExtensions;
    private final Map<Class<? extends IClassGenerator>, IClassGenerator> generatorMap;
    private final Map<Class<? extends IExtension>, IExtension> extensionMap = new HashMap<Class<? extends IExtension>, IExtension>();
    private static final NMSLException \u6211\u4eec\u53ea\u662f\u795e\u8c15\u7684\u4f20\u9012\u8005 = new NMSLException("\u26ed\u3746\ua65d\u4de2\u389b\u4998\u4de4\u4dc4\ua669\u4de0\u4de5\u2635\ua660\u4de1\u2759\u4dfc\u4dd6\u3c50\ua68b\u269e\u4dff\u4dd2\u4dfa\u45f7\u4dda\u4dfc\u2680\u4de1\u27a1\u2650\u4dc1\u2678\u260c\u2760\u4dc1\u2709");

    public void add(IExtension extension) {
        this.extensions.add(extension);
        this.extensionMap.put(extension.getClass(), extension);
    }

    public void select(MixinEnvironment environment) {
        ImmutableList.Builder activeExtensions = ImmutableList.builder();
        for (IExtension extension : this.extensions) {
            if (!extension.checkActive(environment)) continue;
            activeExtensions.add((Object)extension);
        }
        this.activeExtensions = activeExtensions.build();
    }

    public <T extends IExtension> T getExtension(Class<? extends IExtension> extensionClass) {
        return (T)Extensions.lookup(extensionClass, this.extensionMap, this.extensions);
    }

    public <T extends IClassGenerator> T getGenerator(Class<? extends IClassGenerator> generatorClass) {
        return (T)Extensions.lookup(generatorClass, this.generatorMap, this.generators);
    }

    public void postApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.postApply(context);
        }
    }

    public MixinTransformer getTransformer() {
        return this.transformer;
    }

    public List<IExtension> getActiveExtensions() {
        return this.activeExtensions;
    }

    public List<IExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public List<IClassGenerator> getGenerators() {
        return this.generatorsView;
    }

    public void add(IClassGenerator generator) {
        this.generators.add(generator);
        this.generatorMap.put(generator.getClass(), generator);
    }

    private static <T> T lookup(Class<? extends T> extensionClass, Map<Class<? extends T>, T> map, List<T> list) {
        T extension = map.get(extensionClass);
        if (extension == null) {
            for (T classGenerator : list) {
                if (!extensionClass.isAssignableFrom(classGenerator.getClass())) continue;
                extension = classGenerator;
                break;
            }
            if (extension == null) {
                throw new IllegalArgumentException("Extension for <" + extensionClass.getName() + "> could not be found");
            }
            map.put(extensionClass, extension);
        }
        return extension;
    }

    public void export(MixinEnvironment env, String name, boolean force, byte[] bytes) {
        for (IExtension extension : this.activeExtensions) {
            extension.export(env, name, force, bytes);
        }
    }

    public Extensions(MixinTransformer transformer) {
        this.generators = new ArrayList<IClassGenerator>();
        this.generatorsView = Collections.unmodifiableList(this.generators);
        this.generatorMap = new HashMap<Class<? extends IClassGenerator>, IClassGenerator>();
        this.activeExtensions = Collections.emptyList();
        this.transformer = transformer;
    }

    public void preApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.preApply(context);
        }
    }
}

