/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.obfuscation.mapping.common;

import com.google.common.base.Objects;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import pers.XiaoShadiao.NMSLException;

public class MappingMethod
implements IMapping<MappingMethod> {
    private final String desc;
    private final String owner;
    private final String name;
    private static final NMSLException \u53ef\u662f = new NMSLException("\u4ddd\u4dda\u4dec\u4dda\ua678\u2630\u400e\u4ddf\ua68a\u4dd1\u27ae\u2705\u26b3\u4df1\u2608\ua646\u4152\u4ded\u272c\u4de6\u4dc0\u4dc2\u4dd8\ua641\u4dfc\u26a8\u4def\u4de9\u275d\u4dd5\u278f\u262b\u4dd9\u4de6\u4dd2\u2738\u49e0");

    public MappingMethod(String fullyQualifiedName, String desc) {
        this(MappingMethod.getOwnerFromName(fullyQualifiedName), MappingMethod.getBaseName(fullyQualifiedName), desc);
    }

    @Override
    public MappingMethod transform(String newDesc) {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), newDesc);
    }

    @Override
    public MappingMethod move(String newOwner) {
        return new MappingMethod(newOwner, this.getSimpleName(), this.getDesc());
    }

    public MappingMethod addPrefix(String prefix) {
        String simpleName = this.getSimpleName();
        if (simpleName == null || simpleName.startsWith(prefix)) {
            return this;
        }
        return new MappingMethod(this.getOwner(), prefix + simpleName, this.getDesc());
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    @Override
    public MappingMethod getSuper() {
        return null;
    }

    private static String getOwnerFromName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(0, pos) : null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getDesc()});
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MappingMethod) {
            return Objects.equal((Object)this.name, (Object)((MappingMethod)obj).name) && Objects.equal((Object)this.desc, (Object)((MappingMethod)obj).desc);
        }
        return false;
    }

    @Override
    public IMapping.Type getType() {
        return IMapping.Type.METHOD;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public MappingMethod(String owner, String simpleName, String desc) {
        this.owner = owner;
        this.name = simpleName;
        this.desc = desc;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return null;
        }
        return (this.owner != null ? this.owner + "/" : "") + this.name;
    }

    @Override
    public String serialise() {
        return this.toString();
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(pos + 1) : name;
    }

    @Override
    public MappingMethod remap(String newName) {
        return new MappingMethod(this.getOwner(), newName, this.getDesc());
    }

    @Override
    public MappingMethod copy() {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), this.getDesc());
    }

    public String toString() {
        String desc = this.getDesc();
        return String.format("%s%s%s", this.getName(), desc != null ? " " : "", desc != null ? desc : "");
    }
}

