/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private ServiceLoader<IMixinService> serviceLoader;
    private IMixinService service = null;
    private static MixinService instance;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private static final Logger logger;
    private final Set<String> bootedServices = new HashSet<String>();
    private static final NMSLException \u4e0d\u662f\u8868\u9762\u4e0a\u90a3\u4e48\u51b7\u6f20\u7684\u4eba;

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    static {
        \u4e0d\u662f\u8868\u9762\u4e0a\u90a3\u4e48\u51b7\u6f20\u7684\u4eba = new NMSLException("\u4df0\ua658\u4dc9\u4b72\u4dff\ua66e\u4dd1\u4dc5\u4ddd\u44c2\u4dfb\u4dcb\u3847\u4619\u4de1\u4dd7\u274a\u4720\u26c6\u4dd0\u4df6\u4ddd\u26d1\u27bd\u4de9\u4dd9\u26fa\u4dd8\u4de2\u4dc5\u4dd9\u4df6\u4ddb\u4def\ua657\u4dee\u4df4\u4669\u26c5\u4dd3\u4ddb\u273e\u417e\u4df0");
        logger = LogManager.getLogger((String)"mixin");
    }

    private MixinService() {
        this.runBootServices();
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }
}

