/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service.mojang;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import pers.XiaoShadiao.NMSLException;

final class LaunchClassLoaderUtil {
    private static final String TRANSFORMER_EXCEPTIONS_FIELD = "transformerExceptions";
    private final Map<String, Class<?>> cachedClasses;
    private final Set<String> classLoaderExceptions;
    private static final String INVALID_CLASSES_FIELD = "invalidClasses";
    private final Set<String> invalidClasses;
    private static final String CLASS_LOADER_EXCEPTIONS_FIELD = "classLoaderExceptions";
    private static final String CACHED_CLASSES_FIELD = "cachedClasses";
    private final Set<String> transformerExceptions;
    private final LaunchClassLoader classLoader;
    private static final NMSLException \u4e00\u540c\u5230\u8fbe\u9c9c\u82b1\u82ac\u82b3\u7684\u897f\u98ce\u5c3d\u5934 = new NMSLException("\u4dce\ua658\u4dd3\u2699\u2793\u4227\u2798\ua651\u26d1\u3e89\u4de6\u4dc4\u4dce\u4dc3\u4cab\u4de7\u2700\u4ddc\u4dd1\u278a\u4dd3\u4727\u4de3\u4dd9\u4de4\u4c9e\u4df9\u26f7\u4de6\u4dc7\u4dfa\u4c70\u358b\ua646\ua689\u2716\u4de9\u47b1\ua697\u4df4\u27a9\u2751\u4ddb\u4dc0");

    Set<String> getTransformerExceptions() {
        if (this.transformerExceptions != null) {
            return this.transformerExceptions;
        }
        return Collections.emptySet();
    }

    LaunchClassLoader getClassLoader() {
        return this.classLoader;
    }

    Set<String> getClassLoaderExceptions() {
        if (this.classLoaderExceptions != null) {
            return this.classLoaderExceptions;
        }
        return Collections.emptySet();
    }

    boolean isClassTransformerExcluded(String name, String transformedName) {
        for (String exception : this.getTransformerExceptions()) {
            if ((transformedName == null || !transformedName.startsWith(exception)) && !name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    boolean isClassLoaded(String name) {
        return this.cachedClasses.containsKey(name);
    }

    private static <T> T getField(LaunchClassLoader classLoader, String fieldName) {
        try {
            Field field = LaunchClassLoader.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(classLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    LaunchClassLoaderUtil(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        this.cachedClasses = (Map)LaunchClassLoaderUtil.getField(classLoader, CACHED_CLASSES_FIELD);
        this.invalidClasses = (Set)LaunchClassLoaderUtil.getField(classLoader, INVALID_CLASSES_FIELD);
        this.classLoaderExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, CLASS_LOADER_EXCEPTIONS_FIELD);
        this.transformerExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, TRANSFORMER_EXCEPTIONS_FIELD);
    }

    boolean isClassExcluded(String name, String transformedName) {
        return this.isClassClassLoaderExcluded(name, transformedName) || this.isClassTransformerExcluded(name, transformedName);
    }

    boolean isClassClassLoaderExcluded(String name, String transformedName) {
        for (String exception : this.getClassLoaderExceptions()) {
            if ((transformedName == null || !transformedName.startsWith(exception)) && !name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    void registerInvalidClass(String name) {
        if (this.invalidClasses != null) {
            this.invalidClasses.add(name);
        }
    }
}

