/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import pers.XiaoShadiao.NMSLException;

public class ClassSignature {
    private Token superClass;
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    protected static final String OBJECT = "java/lang/Object";
    private final List<Token> interfaces;
    private final Deque<String> rawInterfaces;
    private static final NMSLException \u96c5\u52aa\u8428\u6ce2\u5229\u65af\u7684\u5723\u5973 = new NMSLException("\u4df2\ua661\u4ddd\u272f\u4dcd\u4dc4\ua685\u27b3\u271c\u4dee\u3704\u4de3\u4ddd\ua674\u4de5\u4de5\u37af\u4b1c\ua683\u4df6\u3ceb\u4df5\u4ded\u4dc7\ua697\ua644\u4dc3\u4dd8\u4b69\ua640\u4de5\ua66d\u4de9\u3596\u4de1\u4dea\u4de5\u4dd6\u4df5\u4dfa\u4df8\u4df0\u4de3\u2761\u2758\u4df7\u27ac\u4dff");

    protected void setSuperClass(Token superClass) {
        this.superClass = superClass;
    }

    private String findOffsetName(char c, Set<String> typeVars, String prefix, String suffix) {
        String name = String.format("%s%s%s", prefix, Character.valueOf(c), suffix);
        if (!typeVars.contains(name)) {
            return name;
        }
        if (c > '@' && c < '[') {
            int s = c - 64;
            while (s + 65 != c) {
                name = String.format("%s%s%s", prefix, Character.valueOf((char)(s + 65)), suffix);
                if (!typeVars.contains(name)) {
                    return name;
                }
                ++s;
                s %= 26;
            }
        }
        return null;
    }

    protected void addRawInterface(String iface) {
        Token token = new Token(iface);
        String raw = token.asType(true);
        for (Token intrface : this.interfaces) {
            if (!intrface.asType(true).equals(raw)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    protected TokenHandle getType(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle handle = new TokenHandle();
        this.types.put(new TypeVar(varName), handle);
        return handle;
    }

    private void conform(Set<String> typeVars) {
        for (TypeVar typeVar : this.types.keySet()) {
            String name = this.findUniqueName(typeVar.getOriginalName(), typeVars);
            typeVar.rename(name);
            typeVars.add(name);
        }
    }

    protected TypeVar getTypeVar(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return typeVar;
        }
        return null;
    }

    public void merge(ClassSignature other) {
        try {
            HashSet<String> typeVars = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                typeVars.add(typeVar.toString());
            }
            other.conform(typeVars);
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<TypeVar, TokenHandle> type : other.types.entrySet()) {
            this.addTypeVar(type.getKey(), type.getValue());
        }
        for (Token iface : other.interfaces) {
            this.addInterface(iface);
        }
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature generated = new ClassSignature();
        generated.setSuperClass(new Token(classNode.superName != null ? classNode.superName : OBJECT));
        for (String iface : classNode.interfaces) {
            generated.addInterface(new Token(iface));
        }
        return generated;
    }

    public static ClassSignature of(String signature) {
        return new ClassSignature().read(signature);
    }

    protected String getTypeVar(TokenHandle handle) {
        for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
            TypeVar typeVar = type.getKey();
            TokenHandle typeHandle = type.getValue();
            if (handle != typeHandle && handle.asToken() != typeHandle.asToken()) continue;
            return "T" + typeVar + ";";
        }
        return handle.token.asType();
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    private String findUniqueName(String typeVar, Set<String> typeVars) {
        String name;
        if (!typeVars.contains(typeVar)) {
            return typeVar;
        }
        if (typeVar.length() == 1 && (name = this.findOffsetName(typeVar.charAt(0), typeVars)) != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, typeVar, "");
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "T", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar + "Type");
        if (name != null) {
            return name;
        }
        throw new IllegalStateException("Failed to conform type var: " + typeVar);
    }

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder sb = new StringBuilder();
        if (this.types.size() > 0) {
            boolean valid = false;
            StringBuilder types = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
                String bound = type.getValue().asBound();
                if (bound.isEmpty()) continue;
                types.append(type.getKey()).append(':').append(bound);
                valid = true;
            }
            if (valid) {
                sb.append('<').append((CharSequence)types).append('>');
            }
        }
        sb.append(this.superClass.asType());
        for (Token iface : this.interfaces) {
            sb.append(iface.asType());
        }
        return sb.toString();
    }

    public ClassSignature wake() {
        return this;
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public void addInterface(String iface) {
        this.rawInterfaces.add(iface);
    }

    public String getSuperClass() {
        return this.superClass.asType(true);
    }

    ClassSignature() {
        this.superClass = new Token(OBJECT);
        this.interfaces = new ArrayList<Token>();
        this.rawInterfaces = new LinkedList<String>();
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle handle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException("TypeVar " + typeVar + " is already present on " + this);
        }
        this.types.put(typeVar, handle);
    }

    private ClassSignature read(String signature) {
        if (signature != null) {
            try {
                new SignatureReader(signature).accept(new SignatureParser());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this;
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    protected void addInterface(Token iface) {
        if (!iface.isRaw()) {
            String raw = iface.asType(true);
            ListIterator<Token> iter = this.interfaces.listIterator();
            while (iter.hasNext()) {
                Token intrface = iter.next();
                if (!intrface.isRaw() || !intrface.asType(true).equals(raw)) continue;
                iter.set(iface);
                return;
            }
        }
        this.interfaces.add(iface);
    }

    private String findOffsetName(char c, Set<String> typeVars) {
        return this.findOffsetName(c, typeVars, "", "");
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();
        private static final NMSLException \u7f07\u5b9d\u4e0d\u6015 = new NMSLException("\ua689\u4dc8\u4ded\u4dda\u276f\u4ce7\u358c\u26e7\u4def\u4df8\u4de4\u4de2\u4dcd\u273d\u38e9\u4508\u423c\u27ae\u4dd2\u2700\u2656\u2680\u4dc3\u4df6\u4dd5\ua64c\u4d8c\u2684\u4dc1\ua651\ua649\ua68f\u4dd0\u4deb\ua642\u273b\u2728\ua66b\u26fc\u272e\u4df4");

        @Override
        public void visitTypeVariable(String name) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(name) && (typeVar = ClassSignature.this.getTypeVar(name)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(name);
        }

        SignatureRemapper() {
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.localTypeVars.add(name);
            super.visitFormalTypeParameter(name);
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;
        private static final NMSLException \u6211\u62cd\u4e09 = new NMSLException("\u4646\u377e\u4de9\u265e\u2706\u4dea\ua68b\u4dd5\u4a7f\u4831\ua68d\u4df3\u4dfe\u4dc0\u4dd7\u4ac7\u2674\u4dd9\u4bb6\u4dee\u2708\u4deb\u4dfc\u4dc5\u4de1\u4de2\u439f\ua687\ua66c\ua67a\u3f79\u26c9\u4df2\u4dd2\u4dd9\u4dd1\u4dea\u4856\ua682");

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.param = new FormalParamElement(name);
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        SignatureParser() {
            super(327680);
        }

        class InterfaceElement
        extends TokenElement {
            private static final NMSLException \u7f07\u5b9d\u8001\u5e08\u5f88\u5389\u5bb3\u7684 = new NMSLException("\u4dde\u277b\u4dff\u2744\u4de8\u4dcc\u4ddc\u4dc5\u2615\u3577\u4dd3\u27a0\u271d\ua682\u4dde\u4dfd\u4dfe\u4dce\u4de6\u4dfa\u4df8\u4de3\u4dfe\ua689\u26d4\u4df7\u4dd5\u275f\ua648\u4df8\u4df8\u4af2\u4de6\ua67c\u4dde\ua699");

            InterfaceElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }
        }

        class SuperClassElement
        extends TokenElement {
            private static final NMSLException \u660e\u5929\u89c1 = new NMSLException("\u4ddd\u4ddc\u273a\u42e9\u4dc5\u4df4\ua696\u272f\u4df6\u4dc4\u4dc1\u27bb\u4dd4\u4df9\u4ddf\ua661\u4dc2\u4df3\u26f3\u4de8\ua674\u2723\u3753\u2789\ua682\u4dfa\ua68b\u4df7\u271d\u4dca\u4dd3\u4dfa\u2620\u279a\u4dfc\u4de6\u2752\u4dec\u4df2\u4dc4\ua652");

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }

            SuperClassElement() {
            }
        }

        class BoundElement
        extends TokenElement {
            private final boolean classBound;
            private final TokenElement type;
            private static final NMSLException \u5c0f\u767d\u5440 = new NMSLException("\u3829\u4de6\u26ee\u4deb\u4dcc\u4dec\u3883\u26f0\ua675\u4de9\ua698\u4ded\ua667\u4dcf\u4df9\u4dd8\ua68d\ua663\u4229\u4dcf\ua66b\ua699\u2738\u4dcb\u4dc8\u4df1\u4df2\u4ded\u4dfd\u4de9\u26cb\u26d6\u4dfb\u4dfb\u4dd7\ua68c\u2744\u4dd0\u4ddd\u3b35\u40c5\u4751");

            @Override
            public void visitClassType(String name) {
                this.token = this.type.token.addBound(name, this.classBound);
            }

            BoundElement(TokenElement type, boolean classBound) {
                this.type = type;
                this.classBound = classBound;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final char wildcard;
            private final TokenElement type;
            private static final NMSLException \u5411\u5bbd\u539a\u7684\u5927\u5730\u4f2f\u4f2f\u501f\u98ce = new NMSLException("\u4023\u4dd3\u4dcd\u4dcb\u3d66\u2701\u4ddf\u4dce\u4de7\u4dee\u27b6\u3dad\u26a8\u4dcf\u2725\u4dc2\u2738\u4de0\u4dea\u4dc6\u4dc0\ua697\u4dfe\u4dec\u27b7\u2688\u272e\u4dcf\u4dfa\ua656\ua694\u4dc3\u4dd9\u2710\u2694\u4dc4\u4ddb\u4792\u4de1\u4dc6\u4dd0\u4de8\u449c\u26fb\u4dc2\u4dda\u2666\u4dc4");

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }

            @Override
            public void visitClassType(String name) {
                this.token = this.type.addTypeArgument(name).setWildcard(this.wildcard).asToken();
            }

            TypeArgElement(TokenElement type, char wildcard) {
                this.type = type;
                this.wildcard = wildcard;
            }

            @Override
            public void visitTypeVariable(String name) {
                TokenHandle token = ClassSignature.this.getType(name);
                this.token = this.type.addTypeArgument(token).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.token = this.type.addTypeArgument(descriptor).asToken();
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;
            private static final NMSLException \u660e\u5929\u7684\u660e\u5929\u89c1\u5566 = new NMSLException("\u4dfd\u4ded\u279a\u269e\u4df3\ua696\u26cd\u4dc6\u4de6\ua66f\u4ded\u276e\u4dc5\u4dee\u2706\u4dda\u272f\u4dcc\u4df3\ua688\u4dc6\u4dcd\u4dc8\u4dc1\u26cb\ua661\u4de3\u2690\u4dcb\u2636\u26e9\u273f\u4ddf");

            FormalParamElement(String param) {
                this.handle = ClassSignature.this.getType(param);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            private boolean array;
            protected Token token;
            private static final NMSLException \u60b2\u4f24\u7684\u65f6\u5019 = new NMSLException("\ua69b\u4269\u278a\u4df9\u4dce\u264e\u2795\u4dc3\u4ddf\u4dd9\u273a\u4de5\ua653\u4ded\u4df7\u4dc2\ua67d\u4dd2\u4dc9\u26e7\u4dfc\ua641\u4dca\u3e3d\u4dd1\u2634\u2780\u4dd3\ua67e\u4df9\u4dcf\u4dc9\u4dfe");

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            private boolean getArray() {
                boolean array = this.array;
                this.array = false;
                return array;
            }

            TokenElement() {
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, false);
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            IToken addTypeArgument(String name) {
                return this.token.addTypeArgument(name).setArray(this.getArray());
            }

            Token addTypeArgument() {
                return this.token.addTypeArgument('*').asToken();
            }

            @Override
            public void visitInnerClassType(String name) {
                this.token.addInnerClass(name);
            }

            protected void setArray() {
                this.array = true;
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, true);
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            IToken addTypeArgument(char symbol) {
                return this.token.addTypeArgument(symbol).setArray(this.getArray());
            }

            @Override
            public void visitClassType(String name) {
                this.getToken().setType(name);
            }

            IToken addTypeArgument(TokenHandle token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b81 = new NMSLException("\u2657\u4dc1\u2634\u2623\u2774\u4df0\ua686\u4dcf\u26f2\u2690\u4dc9\u4df8\ua693\u4dc3\u4dc8\u4dee\u2668\u4df7\u268f\u4de1\u39f8\u4dd5\u4dc3\u4de2\ua645\u4dec\u4dee\u4dec\u4dcb\u4dd8\u4def\u44cb\u4dda\u4dea\u4df2\u4dc9\u4dc6\u3ce9\u4de9\u4dd6\u46a7\u2701\u4df0\u2721");

            public SignatureElement() {
                super(327680);
            }
        }
    }

    class TokenHandle
    implements IToken {
        final Token token;
        char wildcard;
        boolean array;
        private static final NMSLException \u5411\u5bbd\u539a\u7684\u5927\u5730\u4f2f\u4f2f\u501f\u98ce = new NMSLException("\ua686\ua663\u4de0\u37f5\ua654\u48c5\ua688\u4df0\ua69b\u4c23\u4de3\ua64a\ua683\u4ddd\u4df5\u4de6\u4412\u38e6\u4dcd\u2798\ua646\u4aa0\ua666\u4cab\u4dd6\u43dc\u35a9\u4dee\u4158\u4dcc\ua64e\u4dcf\ua655\u4dff\u262c\u4de2\u2619\u43b1\u4dc7\u4df4");

        TokenHandle(Token token) {
            this.token = token;
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }

        @Override
        public String asType() {
            StringBuilder sb = new StringBuilder();
            if (this.wildcard > '\u0000') {
                sb.append(this.wildcard);
            }
            if (this.array) {
                sb.append('[');
            }
            return sb.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        TokenHandle() {
            this(new Token());
        }

        public String toString() {
            return this.token.toString();
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) > -1) {
                this.wildcard = wildcard;
            }
            return this;
        }
    }

    static class Token
    implements IToken {
        static final String SYMBOLS = "+-*";
        private List<IToken> signature;
        private List<Token> ifaceBound;
        private final boolean inner;
        private List<IToken> suffix;
        private List<Token> classBound;
        private Token tail;
        private char symbol = '\u0000';
        private String type;
        private boolean array;
        private static final NMSLException \u8fd8\u6709\u4ec7\u6068\u4e0e\u522b\u4eba\u7684\u4ec7\u6068 = new NMSLException("\u2727\ua697\u27a4\ua664\u26d3\u2607\u27a1\u485c\u4de4\u4dd6\u4405\u2670\u4dc5\ua655\u2716\u4dee\u27ac\u2639\u4dfa\u4dea\u4deb\u35e9\u4dcc\u26f7\u4dfc\u4df1\u266a\u4195\u27ab\u273b\u270b\u264c\u4ddf\u4dc7\ua66b\u4df1\u4de8\u4dfd\u4dc5\u4de8\u278d");

        Token(char symbol) {
            this();
            this.symbol = symbol;
        }

        IToken addTypeArgument(TokenHandle token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            TokenHandle handle = token.clone();
            this.getSignature().add(handle);
            return handle;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        Token(String type, boolean inner) {
            this.inner = inner;
            this.type = type;
        }

        @Override
        public String asBound() {
            StringBuilder sb = new StringBuilder();
            if (this.type != null) {
                sb.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    sb.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    sb.append(':').append(token.asType());
                }
            }
            return sb.toString();
        }

        Token setSymbol(char symbol) {
            if (this.symbol == '\u0000' && SYMBOLS.indexOf(symbol) > -1) {
                this.symbol = symbol;
            }
            return this;
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        Token(boolean inner) {
            this(null, inner);
        }

        Token addInnerClass(String name) {
            this.tail = new Token(name, true);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        public String toString() {
            return this.asType();
        }

        Token() {
            this(false);
        }

        boolean hasInterfaceBound() {
            return this.ifaceBound != null;
        }

        String getClassType() {
            return this.type != null ? this.type : ClassSignature.OBJECT;
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }

        public String asType(boolean raw) {
            StringBuilder sb = new StringBuilder();
            if (this.array) {
                sb.append('[');
            }
            if (this.symbol != '\u0000') {
                sb.append(this.symbol);
            }
            if (this.type == null) {
                return sb.toString();
            }
            if (!this.inner) {
                sb.append('L');
            }
            sb.append(this.type);
            if (!raw) {
                if (this.signature != null) {
                    sb.append('<');
                    for (IToken token : this.signature) {
                        sb.append(token.asType());
                    }
                    sb.append('>');
                }
                if (this.suffix != null) {
                    for (IToken token : this.suffix) {
                        sb.append('.').append(token.asType());
                    }
                }
            }
            if (!this.inner) {
                sb.append(';');
            }
            return sb.toString();
        }

        boolean isRaw() {
            return this.signature == null;
        }

        boolean hasClassBound() {
            return this.classBound != null;
        }

        @Override
        public String asType() {
            return this.asType(false);
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) == -1) {
                return this;
            }
            return this.setSymbol(wildcard);
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        IToken addTypeArgument(char symbol) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(symbol);
            }
            Token token = new Token(symbol);
            this.getSignature().add(token);
            return token;
        }

        Token setType(String type) {
            if (this.type == null) {
                this.type = type;
            }
            return this;
        }

        Token addBound(String bound, boolean classBound) {
            if (classBound) {
                return this.addClassBound(bound);
            }
            return this.addInterfaceBound(bound);
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(String name) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(name);
            }
            Token token = new Token(name);
            this.getSignature().add(token);
            return token;
        }

        Token addInterfaceBound(String bound) {
            Token token = new Token(bound);
            this.getIfaceBound().add(token);
            return token;
        }

        @Override
        public Token asToken() {
            return this;
        }

        Token(String type) {
            this(type, false);
        }

        Token addClassBound(String bound) {
            Token token = new Token(bound);
            this.getClassBound().add(token);
            return token;
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public String asType();

        public IToken setWildcard(char var1);

        public Token asToken();

        public IToken setArray(boolean var1);

        public String asBound();
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private final String originalName;
        private String currentName;
        private static final NMSLException \u867d\u7136\u6211\u4eec\u6709\u5404\u81ea\u7684\u4f7f\u547d = new NMSLException("\ua679\u4dde\u41f5\u4754\u2737\u2675\u4df9\u4744\u4dcc\u4dfb\u2726\u4dd5\ua66d\u26ec\ua65c\u4dc9\u4de4\ua652\u4dcf\ua66a\u4dda\u4dce\u266d\u4dec\u279a\u4dc5\u26e3\u265e\u262a\ua652\u27ac");

        String getOriginalName() {
            return this.originalName;
        }

        public boolean matches(String originalName) {
            return this.originalName.equals(originalName);
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }

        public String toString() {
            return this.currentName;
        }

        @Override
        public int compareTo(TypeVar other) {
            return this.currentName.compareTo(other.currentName);
        }

        TypeVar(String name) {
            this.currentName = this.originalName = name;
        }

        public boolean equals(Object obj) {
            return this.currentName.equals(obj);
        }

        void rename(String name) {
            this.currentName = name;
        }
    }

    static class Lazy
    extends ClassSignature {
        private ClassSignature generated;
        private final String sig;
        private static final NMSLException \u5c0f\u654c = new NMSLException("\u4def\u274b\ua65d\u4dd3\u4df3\u4df1\u26ff\u4dfc\u261f\u2650\u37e3\u4df4\u4995\u4de0\ua681\u4df6\u2611\ua69c\u4dec\u4dc0\u4ddc\u4dfc\u2656\u2722\u4dd5\u4ddd\u276a\u4df4\u446d\u27bd\u4de8\u4dd8\u4de5\u4d1a\u4dd3\u457f\u4de3\u4ddb\u4dff\u4dd5\u4df7\ua693\u481c\u272c\u270c\u4dc2");

        Lazy(String sig) {
            this.sig = sig;
        }

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }
    }
}

