/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.NMSLException;

public final class ConstraintParser {
    private static final NMSLException \u770b\u597d\u7f07\u5b9d\u8001\u5e08\u7684\u52a8\u4f5c = new NMSLException("\ua696\u4de0\u4575\u4de1\u4dd4\u2622\u4de8\u4dce\u4a0e\u2785\u4dd0\u4ddb\u4dea\u4dfb\u4b2d\u4dc9\u4df9\u2636\u4dc9\u4dfe\u4bd0\u4dc3\u46b9\u2684\u4df7\u278a\u27b0\u273a\u4dfe\u26f8\u4dd5\ua65c\ua65c\u2642\u4dff\ua678\u4dec\ua693\u4dce\u4df2\u4dff");

    private ConstraintParser() {
    }

    public static Constraint parse(AnnotationNode annotation) {
        String constraints = Annotations.getValue(annotation, "constraints", "");
        return ConstraintParser.parse(constraints);
    }

    public static Constraint parse(String expr) {
        if (expr == null || expr.length() == 0) {
            return Constraint.NONE;
        }
        String[] exprs = expr.replaceAll("\\s", "").toUpperCase().split(";");
        Constraint head = null;
        for (String subExpr : exprs) {
            Constraint next = new Constraint(subExpr);
            if (head == null) {
                head = next;
                continue;
            }
            head.append(next);
        }
        return head != null ? head : Constraint.NONE;
    }

    public static class Constraint {
        private Constraint next;
        private final String expr;
        private String token;
        private int min = Integer.MIN_VALUE;
        private static final Pattern pattern;
        private int max = Integer.MAX_VALUE;
        private String[] constraint;
        public static final Constraint NONE;
        private static final NMSLException \u548c\u5988\u5988\u4e00\u6837;

        public int getMin() {
            return this.min;
        }

        static {
            \u548c\u5988\u5988\u4e00\u6837 = new NMSLException("\u4ddd\u4dc1\u4dfa\u2644\u2753\u4dec\u4dfd\u263f\u4dc3\u3bd9\u4dec\u4716\u2702\u4def\u4dc6\u4dfd\ua69a\u4dd5\u4de6\u4de5\u277d\ua687\u2608\u3aa5\ua652\ua676\u269a\u4dca\u4dcd\u270c\u4de9\u4dca\u4dff\u26f5\u4df6\u4dd8\u4de6\u41ea\ua685\u271d\u26e0\u2796");
            NONE = new Constraint();
            pattern = Pattern.compile("^([A-Z0-9\\-_\\.]+)\\((?:(<|<=|>|>=|=)?([0-9]+)(<|(-)([0-9]+)?|>|(\\+)([0-9]+)?)?)?\\)$");
        }

        private String elem(int index) {
            return this.constraint[index];
        }

        Constraint(String expr) {
            this.expr = expr;
            Matcher matcher = pattern.matcher(expr);
            if (!matcher.matches()) {
                throw new InvalidConstraintException("Constraint syntax was invalid parsing: " + this.expr);
            }
            this.token = matcher.group(1);
            this.constraint = new String[]{matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8)};
            this.parse();
        }

        private Constraint() {
            this.expr = null;
            this.token = "*";
            this.constraint = new String[0];
        }

        private boolean has(int index) {
            return this.constraint[index] != null;
        }

        public String toString() {
            return String.format("Constraint(%s [%d-%d])", this.token, this.min, this.max);
        }

        private void parse() {
            if (!this.has(1)) {
                return;
            }
            this.min = this.val(1);
            this.max = this.min++;
            boolean hasModifier = this.has(0);
            if (this.has(4)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.val(4);
                if (this.max < this.min) {
                    throw new InvalidConstraintException("Invalid range specified '" + this.max + "' is less than " + this.min + " in " + this.expr);
                }
                return;
            }
            if (this.has(6)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.min + this.val(6);
                return;
            }
            if (hasModifier) {
                if (this.has(3)) {
                    throw new InvalidConstraintException("Unexpected trailing modifier '" + this.elem(3) + "' in " + this.expr);
                }
                String leading = this.elem(0);
                if (">".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if (">=".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if ("<".equals(leading)) {
                    this.max = --this.min;
                    this.min = Integer.MIN_VALUE;
                } else if ("<=".equals(leading)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                }
            } else if (this.has(2)) {
                String trailing = this.elem(2);
                if ("<".equals(trailing)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                } else {
                    this.max = Integer.MAX_VALUE;
                }
            }
        }

        public int getMax() {
            return this.max;
        }

        public String getRangeHumanReadable() {
            if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
                return "ANY VALUE";
            }
            if (this.min == Integer.MIN_VALUE) {
                return String.format("less than or equal to %d", this.max);
            }
            if (this.max == Integer.MAX_VALUE) {
                return String.format("greater than or equal to %d", this.min);
            }
            if (this.min == this.max) {
                return String.format("%d", this.min);
            }
            return String.format("between %d and %d", this.min, this.max);
        }

        private int val(int index) {
            return this.constraint[index] != null ? Integer.parseInt(this.constraint[index]) : 0;
        }

        public String getToken() {
            return this.token;
        }

        public void check(ITokenProvider environment) throws ConstraintViolationException {
            if (this != NONE) {
                Integer value = environment.getToken(this.token);
                if (value == null) {
                    throw new ConstraintViolationException("The token '" + this.token + "' could not be resolved in " + environment, this);
                }
                if (value < this.min) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is less than the minimum value " + this.min + " in " + environment, this, (int)value);
                }
                if (value > this.max) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is greater than the maximum value " + this.max + " in " + environment, this, (int)value);
                }
            }
            if (this.next != null) {
                this.next.check(environment);
            }
        }

        void append(Constraint next) {
            if (this.next != null) {
                this.next.append(next);
                return;
            }
            this.next = next;
        }
    }
}

