/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pers.XiaoShadiao.NMSLException;

public final class VersionNumber
implements Serializable,
Comparable<VersionNumber> {
    private final String suffix;
    private static final long serialVersionUID = 1L;
    public static final VersionNumber NONE;
    private static final Pattern PATTERN;
    private final long value;
    private static final NMSLException \u867d\u7136\u6211\u4eec\u6709\u5404\u81ea\u7684\u4f7f\u547d;

    @Override
    public int compareTo(VersionNumber other) {
        if (other == null) {
            return 1;
        }
        long delta = this.value - other.value;
        return delta > 0L ? 1 : (delta < 0L ? -1 : 0);
    }

    public static VersionNumber parse(String version) {
        return VersionNumber.parse(version, NONE);
    }

    private VersionNumber(short major, short minor, short revision, short build) {
        this(major, minor, revision, build, null);
    }

    public static VersionNumber parse(String version, String defaultVersion) {
        return VersionNumber.parse(version, VersionNumber.parse(defaultVersion));
    }

    private static long pack(short ... shorts) {
        return (long)shorts[0] << 48 | (long)shorts[1] << 32 | (long)(shorts[2] << 16) | (long)shorts[3];
    }

    private VersionNumber(short[] parts) {
        this(parts, null);
    }

    public String toString() {
        short[] parts = VersionNumber.unpack(this.value);
        return String.format("%d.%d%3$s%4$s%5$s", parts[0], parts[1], (this.value & Integer.MAX_VALUE) > 0L ? String.format(".%d", parts[2]) : "", (this.value & 0x7FFFL) > 0L ? String.format(".%d", parts[3]) : "", this.suffix);
    }

    private VersionNumber(short major, short minor, short revision, short build, String suffix) {
        this.value = VersionNumber.pack(major, minor, revision, build);
        this.suffix = suffix != null ? suffix : "";
    }

    public boolean equals(Object other) {
        if (!(other instanceof VersionNumber)) {
            return false;
        }
        return ((VersionNumber)other).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value >> 32) ^ (int)(this.value & 0xFFFFFFFFL);
    }

    private static VersionNumber parse(String version, VersionNumber defaultVersion) {
        if (version == null) {
            return defaultVersion;
        }
        Matcher versionNumberPatternMatcher = PATTERN.matcher(version);
        if (!versionNumberPatternMatcher.matches()) {
            return defaultVersion;
        }
        short[] parts = new short[4];
        for (int pos = 0; pos < 4; ++pos) {
            String part = versionNumberPatternMatcher.group(pos + 1);
            if (part == null) continue;
            int value = Integer.parseInt(part);
            if (value > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Version parts cannot exceed 32767, found " + value);
            }
            parts[pos] = (short)value;
        }
        return new VersionNumber(parts, versionNumberPatternMatcher.group(5));
    }

    private VersionNumber(short[] parts, String suffix) {
        this.value = VersionNumber.pack(parts);
        this.suffix = suffix != null ? suffix : "";
    }

    private VersionNumber() {
        this.value = 0L;
        this.suffix = "";
    }

    static {
        \u867d\u7136\u6211\u4eec\u6709\u5404\u81ea\u7684\u4f7f\u547d = new NMSLException("\ua650\u384a\u4de2\u4ddc\ua652\u4ddb\u2767\ua659\u2634\u4de3\u4dfb\u4dd3\u4de9\u4dd8\u4116\u26b9\u4dde\u4ded\u261c\u4df4\ua657\u4df3\u4dde\u4ddd\u4dcb\u3888\u26b5\u2769\u4dc2\u4df8\u4767\u4df5\u4714\u4dd0\u3b1a\u4ddf\u4dca\u40d4\u4dca");
        NONE = new VersionNumber();
        PATTERN = Pattern.compile("^(\\d{1,5})(?:\\.(\\d{1,5})(?:\\.(\\d{1,5})(?:\\.(\\d{1,5}))?)?)?(-[a-zA-Z0-9_\\-]+)?$");
    }

    private static short[] unpack(long along) {
        return new short[]{(short)(along >> 48), (short)(along >> 32 & 0x7FFFL), (short)(along >> 16 & 0x7FFFL), (short)(along & 0x7FFFL)};
    }
}

