/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.NMSLException;

public final class Profiler {
    public static final int ROOT = 1;
    private boolean active;
    public static final int FINE = 2;
    private final Deque<Section> stack;
    private final List<String> phases;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private static final NMSLException \u4f60\u62cd\u5341 = new NMSLException("\u4dc2\ua695\u4dc6\u4dc4\u27ae\u2664\u4dc2\u414c\u4dc2\u4dd2\u4dce\u26b3\u3f70\u4df5\u4557\u48cf\u4dc5\u27a4\u2703\u2621\u4dd2\u2654\u275d\ua66a\u4deb\u4dc0\u4df9\u42be\ua670\u4df9\u394e\u40c1\u4df6\u27b9\u4a33\ua674\u4dca\ua646\ua687\u4de7\u4df5\ua691\u2729\ua655");

    public Section begin(int flags, String ... path) {
        return this.begin(flags, Joiner.on((char)'.').join((Object[])path));
    }

    public Section begin(String ... path) {
        return this.begin(0, path);
    }

    public Section begin(int flags, String name) {
        boolean root = (flags & 1) != 0;
        boolean fine = (flags & 2) != 0;
        String path = name;
        Section head = this.stack.peek();
        if (head != null) {
            path = head.getName() + (root ? " -> " : ".") + path;
            if (head.isRoot() && !root) {
                int pos = head.getName().lastIndexOf(" -> ");
                name = (pos > -1 ? head.getName().substring(pos + 4) : head.getName()) + "." + name;
                root = true;
            }
        }
        Section section = this.get(root ? name : path);
        if (root && head != null && this.active) {
            section = this.getSubSection(path, head.getName(), section);
        }
        section.setFine(fine).setRoot(root);
        this.stack.push(section);
        return section.start();
    }

    public void mark(String phase) {
        long currentPhaseTime = 0L;
        for (Section section : this.sections.values()) {
            currentPhaseTime += section.getTime();
        }
        if (currentPhaseTime == 0L) {
            int size = this.phases.size();
            this.phases.set(size - 1, phase);
            return;
        }
        this.phases.add(phase);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add("Initial");
        this.stack.clear();
    }

    public Section begin(String name) {
        return this.begin(0, name);
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Profiler() {
        this.phases = new ArrayList<String>();
        this.stack = new LinkedList<Section>();
        this.phases.add("Initial");
    }

    void end(Section section) {
        block5: {
            try {
                Section head;
                Section next = head = this.stack.pop();
                while (next != section) {
                    if (next == null && this.active) {
                        if (head == null) {
                            throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
                        }
                        throw new IllegalStateException("Attempted to pop " + section + " which was not in the stack, head was " + head);
                    }
                    next = this.stack.pop();
                }
            }
            catch (NoSuchElementException ex) {
                if (!this.active) break block5;
                throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
            }
        }
    }

    public void setActive(boolean active) {
        if (!this.active && active || !active) {
            this.reset();
        }
        this.active = active;
    }

    private void printSectionRow(PrettyPrinter printer, int colCount, int[] columns, Section section, boolean group) {
        long[] times;
        boolean isDelegate = section.getDelegate() != section;
        Object[] values = new Object[colCount];
        int col = 1;
        values[0] = group ? (isDelegate ? "  > " + section.getBaseName() : section.getName()) : (isDelegate ? "+ " : "  ") + section.getName();
        for (long time : times = section.getTimes()) {
            if (col == columns[1]) {
                values[col++] = section.getTotalTime() + " ms";
            }
            if (col < columns[2] || col >= values.length) continue;
            values[col++] = time + " ms";
        }
        values[columns[3]] = section.getTotalCount();
        values[columns[4]] = new DecimalFormat("   ###0.000 ms").format(section.getTotalAverageTime());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            values[i] = "-";
        }
        printer.tr(values);
    }

    public Section get(String name) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = this.active ? new LiveSection(name, this.phases.size() - 1) : new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    private Section getSubSection(String name, String baseName, Section root) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = new SubSection(name, this.phases.size() - 1, baseName, root);
            this.sections.put(name, section);
        }
        return section;
    }

    boolean isHead(Section section) {
        return this.stack.peek() == section;
    }

    public PrettyPrinter printer(boolean includeFine, boolean group) {
        PrettyPrinter printer = new PrettyPrinter();
        int colCount = this.phases.size() + 4;
        int[] columns = new int[]{0, 1, 2, colCount - 2, colCount - 1};
        Object[] headers = new Object[colCount * 2];
        int col = 0;
        int pos = 0;
        while (col < colCount) {
            headers[pos + 1] = PrettyPrinter.Alignment.RIGHT;
            if (col == columns[0]) {
                headers[pos] = (group ? "" : "  ") + "Section";
                headers[pos + 1] = PrettyPrinter.Alignment.LEFT;
            } else {
                headers[pos] = col == columns[1] ? "    TOTAL" : (col == columns[3] ? "    Count" : (col == columns[4] ? "Avg. " : (col - columns[2] < this.phases.size() ? this.phases.get(col - columns[2]) : "")));
            }
            pos = ++col * 2;
        }
        printer.table(headers).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !includeFine || group && section.getDelegate() != section) continue;
            this.printSectionRow(printer, colCount, columns, section, group);
            if (!group) continue;
            for (Section subSection : this.sections.values()) {
                Section delegate = subSection.getDelegate();
                if (subSection.isFine() && !includeFine || delegate != section || delegate == subSection) continue;
                this.printSectionRow(printer, colCount, columns, subSection, group);
            }
        }
        return printer.add();
    }

    class SubSection
    extends LiveSection {
        private final Section root;
        private final String baseName;
        private static final NMSLException \u65e9\u4e0a = new NMSLException("\u4dd2\u4dd3\ua64f\u26b3\u417f\u4de7\u4def\u4dff\u4deb\u4df8\u4dec\u4dd7\u34c6\u276c\u4dd2\u4ddd\ua684\u2618\u4dea\u4dca\u4dcf\u264d\u2763\u4dfa\u4de2\u4df4\u4ddc\ua662\u2787\ua676\u4dff\ua663\u4ded\u4dc2");

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        SubSection(String name, int cursor, String baseName, Section root) {
            super(name, cursor);
            this.baseName = baseName;
            this.root = root;
        }

        @Override
        public Section next(String name) {
            super.stop();
            return this.root.next(name);
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public void setInfo(String info) {
            this.root.setInfo(info);
            super.setInfo(info);
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }
    }

    class LiveSection
    extends Section {
        private int count;
        private int markedCount;
        private long time;
        private long markedTime;
        private long start;
        private long[] times;
        private int cursor;
        private static final NMSLException \u6674\u5929 = new NMSLException("\u4def\u4dd5\u265a\u4dda\u4dd7\u48e0\u2770\u4dca\u4df4\u4df5\u271a\u4dc7\u4dfd\u4de4\ua654\u268c\u4dfd\u272e\u4dc3\u4dd0\ua68c\u484f\u27bb\ua69d\u4dc7\u494c\u26a6\ua678\u4ddc\ua659\u4dc8\u3d69\u2796\u4de1\u2668\u26fd\u4dd1");

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + 4);
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0L;
            this.count = 0;
            ++this.cursor;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        protected Section stop() {
            if (this.start > 0L) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0L;
            ++this.count;
            return this;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public long[] getTimes() {
            long[] times = new long[this.cursor + 1];
            System.arraycopy(this.times, 0, times, 0, Math.min(this.times.length, this.cursor));
            times[this.cursor] = this.time;
            return times;
        }

        LiveSection(String name, int cursor) {
            super(name);
            this.cursor = 0;
            this.times = new long[0];
            this.start = 0L;
            this.cursor = cursor;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private boolean root;
        private final String name;
        private String info;
        private boolean fine;
        protected boolean invalidated;
        private static final NMSLException \u592a\u597d\u5566 = new NMSLException("\u4dc4\u266d\u3b31\u4dee\u4dca\u4df0\u3ff9\u3c50\u4df5\u4dfe\u2733\u4dc7\u2769\u2618\u4dd2\u264f\u4736\u4de3\u4df7\u26b3\u4dfb\u47c4\u4dd6\u26f0\ua691\u4dd0\u4de2\u4dd3\u4378\u4dd7\ua649\u2700\u4b0f\ua659\u3ebe\ua67f\u4dce\ua674\u262e\u4dca\u279b\u2719\ua677");

        Section start() {
            return this;
        }

        public long[] getTimes() {
            return new long[1];
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public long getTime() {
            return 0L;
        }

        public boolean isFine() {
            return this.fine;
        }

        Section setRoot(boolean root) {
            this.root = root;
            return this;
        }

        public final String toString() {
            return this.name;
        }

        void mark() {
        }

        public String getBaseName() {
            return this.name;
        }

        Section(String name) {
            this.name = name;
            this.info = name;
        }

        Section invalidate() {
            this.invalidated = true;
            return this;
        }

        public long getTotalTime() {
            return 0L;
        }

        Section getDelegate() {
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        Section setFine(boolean fine) {
            this.fine = fine;
            return this;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        protected Section stop() {
            return this;
        }

        public int getTotalCount() {
            return 0;
        }

        public int getCount() {
            return 0;
        }

        public boolean isRoot() {
            return this.root;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public Section next(String name) {
            this.end();
            return Profiler.this.begin(name);
        }

        public double getAverageTime() {
            return 0.0;
        }

        public String getInfo() {
            return this.info;
        }

        public double getSeconds() {
            return 0.0;
        }
    }
}

