/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import pers.XiaoShadiao.NMSLException;

class Mappings
implements IMappingConsumer {
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingField>> fieldMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingField>>();
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>> methodMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>>();
    private UniqueMappings unique;
    private static final NMSLException \u6211\u62cd\u4e94 = new NMSLException("\ua681\u4dfa\ua673\u4dc7\u4dc8\u26e2\u4de9\u2608\u435a\u4dda\u4dd2\u4dd3\u4de6\u4956\u4deb\u40e4\ua646\ua649\u2760\u4589\ua647\u4de4\u4dfd\u4dc1\u4dc9\u4dd3\u4dd3\u26a6\u279f\u4dc3\u3965\u4de3\u26e4\u4dd7\u4de5\u4de8\u4dc4\u4dc7\u4de2\u2744\u4dce\u4de1\u4dc1\ua693\u4dda\u4bb6\u4de6\u4dc1\ua658");

    public IMappingConsumer asUnique() {
        if (this.unique == null) {
            this.unique = new UniqueMappings(this);
        }
        return this.unique;
    }

    @Override
    public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.methodMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    @Override
    public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
        IMappingConsumer.MappingSet<MappingMethod> mappings = this.methodMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.methodMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingMethod>(from, to));
    }

    @Override
    public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.fieldMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    @Override
    public void clear() {
        this.fieldMappings.clear();
        this.methodMappings.clear();
        if (this.unique != null) {
            this.unique.clearMaps();
        }
        this.init();
    }

    private void init() {
        for (ObfuscationType obfType : ObfuscationType.types()) {
            this.fieldMappings.put(obfType, new IMappingConsumer.MappingSet());
            this.methodMappings.put(obfType, new IMappingConsumer.MappingSet());
        }
    }

    public Mappings() {
        this.init();
    }

    @Override
    public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
        IMappingConsumer.MappingSet<MappingField> mappings = this.fieldMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.fieldMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingField>(from, to));
    }

    static class UniqueMappings
    implements IMappingConsumer {
        private final IMappingConsumer mappings;
        private final Map<ObfuscationType, Map<MappingField, MappingField>> fields = new HashMap<ObfuscationType, Map<MappingField, MappingField>>();
        private final Map<ObfuscationType, Map<MappingMethod, MappingMethod>> methods = new HashMap<ObfuscationType, Map<MappingMethod, MappingMethod>>();
        private static final NMSLException \u628a\u7f07\u5b9d\u7684\u8111\u888b\u90fd\u542c\u5927\u4e86 = new NMSLException("\ua673\u4dc3\u4dd0\u4df0\u4dc3\u272c\u3dfb\u4df5\u4df2\u27b8\u4dd6\ua683\u4dc9\u4dc5\u4df8\u273b\ua658\u2690\u4dc6\u4dfa\u4824\u4dd5\u4de8\u4dc8\u2653\u3a79\u4dea\u275e\u42b9\ua642\u4dde\u4dce\u27aa\u4df4\u26a6\u4b0a\u260f");

        @Override
        public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
            return this.mappings.getFieldMappings(type);
        }

        @Override
        public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
            if (!this.checkForExistingMapping(type, from, to, this.fields)) {
                this.mappings.addFieldMapping(type, from, to);
            }
        }

        @Override
        public void clear() {
            this.clearMaps();
            this.mappings.clear();
        }

        protected void clearMaps() {
            this.fields.clear();
            this.methods.clear();
        }

        private <TMapping extends IMapping<TMapping>> boolean checkForExistingMapping(ObfuscationType type, TMapping from, TMapping to, Map<ObfuscationType, Map<TMapping, TMapping>> mappings) throws MappingConflictException {
            IMapping existing;
            Map<TMapping, TMapping> existingMappings = mappings.get(type);
            if (existingMappings == null) {
                existingMappings = new HashMap<TMapping, TMapping>();
                mappings.put(type, existingMappings);
            }
            if ((existing = (IMapping)existingMappings.get(from)) != null) {
                if (existing.equals(to)) {
                    return true;
                }
                throw new MappingConflictException(existing, to);
            }
            existingMappings.put(from, to);
            return false;
        }

        @Override
        public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
            if (!this.checkForExistingMapping(type, from, to, this.methods)) {
                this.mappings.addMethodMapping(type, from, to);
            }
        }

        public UniqueMappings(IMappingConsumer mappings) {
            this.mappings = mappings;
        }

        @Override
        public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
            return this.mappings.getMethodMappings(type);
        }
    }

    public static class MappingConflictException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IMapping<?> newMapping;
        private final IMapping<?> oldMapping;
        private static final NMSLException \u558f = new NMSLException("\u4dde\ua656\u267b\u4dcb\u4df0\u279c\u2670\u4dc4\u4dd3\u4c7c\u4dc1\u4dee\u4dc5\u4de0\ua643\ua698\u4ddb\ua64d\u265f\u2670\u4dcf\u4dc9\u278e\u4df0\u3990\u36a6\u39d4\u2690\u2750\ua667\u2613\ua671\u4de0\u4df5\u4dd5\u4dc1\u4dff\u4dc0\u4dc0\u4dfd\u3640\u4dd1\u4de2\ua669\u4dce");

        public MappingConflictException(IMapping<?> oldMapping, IMapping<?> newMapping) {
            this.oldMapping = oldMapping;
            this.newMapping = newMapping;
        }

        public IMapping<?> getOld() {
            return this.oldMapping;
        }

        public IMapping<?> getNew() {
            return this.newMapping;
        }
    }
}

