/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.ObfuscationUtil;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.mapping.IMappingProvider;
import org.spongepowered.tools.obfuscation.mapping.IMappingWriter;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

public abstract class ObfuscationEnvironment
implements IObfuscationEnvironment {
    protected final List<String> inFileNames;
    protected final ObfuscationType type;
    protected final RemapperProxy remapper = new RemapperProxy();
    protected final String outFileName;
    protected final IMappingWriter mappingWriter;
    protected final IMixinAnnotationProcessor ap;
    protected final IMappingProvider mappingProvider;
    private boolean initDone;
    private static final NMSLException \u6342\u8033\u6735 = new NMSLException("\u4dff\u27bc\ua682\u4dd4\u2657\ua666\u4df1\u4dc3\u4df8\ua665\u4dee\u4df9\u4dec\u35c3\u4dd5\u26e0\u2643\u4de5\ua642\u27a6\u2762\u4de9\ua664\u49d8\u2787\u2780\ua65c\u4761\u4df1\u26ae\u2608\u260b\u27b3\u4df2\u267f\u4ddb\u4dd1\u276d\u4dee\u27aa\u26d0\u4dfe\u2648\u4de7\ua685");

    public String toString() {
        return this.type.toString();
    }

    @Override
    public MappingMethod getObfMethod(MappingMethod method) {
        return this.getObfMethod(method, true);
    }

    protected abstract IMappingWriter getMappingWriter(Messager var1, Filer var2);

    @Override
    public MappingMethod getObfMethod(MappingMethod method, boolean lazyRemap) {
        if (this.initMappings()) {
            String remappedOwner;
            boolean remapped = true;
            Object mapping = null;
            for (Object md = method; md != null && mapping == null; md = ((MappingMethod)md).getSuper()) {
                mapping = this.mappingProvider.getMethodMapping((MappingMethod)md);
            }
            if (mapping == null) {
                if (lazyRemap) {
                    return null;
                }
                mapping = method.copy();
                remapped = false;
            }
            if ((remappedOwner = this.getObfClass(((MappingMethod)mapping).getOwner())) == null || remappedOwner.equals(method.getOwner()) || remappedOwner.equals(((MappingMethod)mapping).getOwner())) {
                return remapped ? mapping : null;
            }
            if (remapped) {
                return ((MappingMethod)mapping).move(remappedOwner);
            }
            String desc = ObfuscationUtil.mapDescriptor(((MappingMethod)mapping).getDesc(), this.remapper);
            return new MappingMethod(remappedOwner, ((MappingMethod)mapping).getSimpleName(), desc);
        }
        return null;
    }

    @Override
    public String getObfClass(String className) {
        if (!this.initMappings()) {
            return null;
        }
        return this.mappingProvider.getClassMapping(className);
    }

    protected ObfuscationEnvironment(ObfuscationType type) {
        this.type = type;
        this.ap = type.getAnnotationProcessor();
        this.inFileNames = type.getInputFileNames();
        this.outFileName = type.getOutputFileName();
        this.mappingProvider = this.getMappingProvider(this.ap, this.ap.getProcessingEnvironment().getFiler());
        this.mappingWriter = this.getMappingWriter(this.ap, this.ap.getProcessingEnvironment().getFiler());
    }

    @Override
    public void writeMappings(Collection<IMappingConsumer> consumers) {
        IMappingConsumer.MappingSet<MappingField> fields = new IMappingConsumer.MappingSet<MappingField>();
        IMappingConsumer.MappingSet<MappingMethod> methods = new IMappingConsumer.MappingSet<MappingMethod>();
        for (IMappingConsumer mappings : consumers) {
            fields.addAll(mappings.getFieldMappings(this.type));
            methods.addAll(mappings.getMethodMappings(this.type));
        }
        this.mappingWriter.write(this.outFileName, this.type, fields, methods);
    }

    public ObfuscationType getType() {
        return this.type;
    }

    @Override
    public MappingField getObfField(MappingField field, boolean lazyRemap) {
        String remappedOwner;
        if (!this.initMappings()) {
            return null;
        }
        MappingField mapping = this.mappingProvider.getFieldMapping(field);
        if (mapping == null) {
            if (lazyRemap) {
                return null;
            }
            mapping = field;
        }
        if ((remappedOwner = this.getObfClass(mapping.getOwner())) == null || remappedOwner.equals(field.getOwner()) || remappedOwner.equals(mapping.getOwner())) {
            return mapping != field ? mapping : null;
        }
        return mapping.move(remappedOwner);
    }

    @Override
    public String remapDescriptor(String desc) {
        return ObfuscationUtil.mapDescriptor(desc, this.remapper);
    }

    @Override
    public MappingMethod getObfMethod(MemberInfo method) {
        MappingMethod obfd = this.getObfMethod(method.asMethodMapping());
        if (obfd != null || !method.isFullyQualified()) {
            return obfd;
        }
        TypeHandle type = this.ap.getTypeProvider().getTypeHandle(method.owner);
        if (type == null || type.isImaginary()) {
            return null;
        }
        TypeMirror superClass = type.getElement().getSuperclass();
        if (superClass.getKind() != TypeKind.DECLARED) {
            return null;
        }
        String superClassName = ((TypeElement)((DeclaredType)superClass).asElement()).getQualifiedName().toString();
        return this.getObfMethod(new MemberInfo(method.name, superClassName.replace('.', '/'), method.desc, method.matchAll));
    }

    protected abstract IMappingProvider getMappingProvider(Messager var1, Filer var2);

    @Override
    public MemberInfo remapDescriptor(MemberInfo method) {
        String newDesc;
        String desc;
        String newOwner;
        boolean transformed = false;
        String owner = method.owner;
        if (owner != null && (newOwner = this.remapper.map(owner)) != null) {
            owner = newOwner;
            transformed = true;
        }
        if ((desc = method.desc) != null && !(newDesc = ObfuscationUtil.mapDescriptor(method.desc, this.remapper)).equals(method.desc)) {
            desc = newDesc;
            transformed = true;
        }
        return transformed ? new MemberInfo(method.name, owner, desc, method.matchAll) : null;
    }

    private boolean initMappings() {
        if (!this.initDone) {
            this.initDone = true;
            if (this.inFileNames == null) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "The " + this.type.getConfig().getInputFileOption() + " argument was not supplied, obfuscation processing will not occur");
                return false;
            }
            int successCount = 0;
            for (String inputFileName : this.inFileNames) {
                File inputFile = new File(inputFileName);
                try {
                    if (!inputFile.isFile()) continue;
                    this.ap.printMessage(Diagnostic.Kind.NOTE, "Loading " + this.type + " mappings from " + inputFile.getAbsolutePath());
                    this.mappingProvider.read(inputFile);
                    ++successCount;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (successCount < 1) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "No valid input files for " + this.type + " could be read, processing may not be sucessful.");
                this.mappingProvider.clear();
            }
        }
        return !this.mappingProvider.isEmpty();
    }

    @Override
    public MappingField getObfField(MemberInfo field) {
        return this.getObfField(field.asFieldMapping(), true);
    }

    @Override
    public MappingField getObfField(MappingField field) {
        return this.getObfField(field, true);
    }

    final class RemapperProxy
    implements ObfuscationUtil.IClassRemapper {
        private static final NMSLException \u8981\u6765\u4e86\u4e48 = new NMSLException("\u36ec\u4de2\u4dea\u2603\u268a\u3eb8\u4608\u4de1\u4dec\u4dec\u4df1\u26d4\ua640\u2743\u4de6\u266b\ua67c\u26eb\u4df4\u2777\u2616\u4df3\u4dd9\u2652\u4de6\u27a6\u2609\u4ded\u4de4\u4df8\u4de6\u4dd7\u3ed6\u4c9c\u4dd4\ua649\u27b0");

        @Override
        public String map(String typeName) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(typeName);
        }

        @Override
        public String unmap(String typeName) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(typeName);
        }

        RemapperProxy() {
        }
    }
}

