/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationType {
    private final IOptionProvider options;
    private final String key;
    private final IMixinAnnotationProcessor ap;
    private final ObfuscationTypeDescriptor descriptor;
    private static final Map<String, ObfuscationType> types;
    private static final NMSLException \u6211\u662f\u7f07\u5b89;

    static {
        \u6211\u662f\u7f07\u5b89 = new NMSLException("\u2785\ua695\u4dc4\u26ac\u4786\u4dcd\u4def\u2712\u4def\u4dde\ua678\u4dfc\u4dfa\u45fb\u4df1\u2616\u4dd6\u4df4\u4dcb\u2744\u416f\u4df7\u27b9\u274d\u2710\ua646\u4dd4\u4dfc\u4ddd\u2792\u4dde\ua694\u4dc3\u2622\u4dc6\u267e\ua685\u4de7\u2733\u4dd7\u3b66\ua66b\u4def\u3f93");
        types = new LinkedHashMap<String, ObfuscationType>();
    }

    private ObfuscationType(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        this.key = descriptor.getKey();
        this.descriptor = descriptor;
        this.ap = ap;
        this.options = ap;
    }

    public boolean isSupported() {
        return this.getInputFileNames().size() > 0;
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public String toString() {
        return this.key;
    }

    public List<String> getInputFileNames() {
        String extraInputFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String inputFile = this.options.getOption(this.descriptor.getInputFileOption());
        if (inputFile != null) {
            builder.add((Object)inputFile);
        }
        if ((extraInputFiles = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            for (String extraInputFile : extraInputFiles.split(";")) {
                builder.add((Object)extraInputFile.trim());
            }
        }
        return builder.build();
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> cls = this.descriptor.getEnvironmentType();
            Constructor<? extends ObfuscationEnvironment> ctor = cls.getDeclaredConstructor(ObfuscationType.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public static ObfuscationType get(String key) {
        ObfuscationType type = types.get(key);
        if (type == null) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was not registered");
        }
        return type;
    }

    public boolean isDefault() {
        String defaultEnv = this.options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this.key.equals("searge") || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public String getKey() {
        return this.key;
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        String key = descriptor.getKey();
        if (types.containsKey(key)) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was already registered");
        }
        ObfuscationType type = new ObfuscationType(descriptor, ap);
        types.put(key, type);
        return type;
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }
}

