/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.service.ILegacyClassTransformer;

public final class Proxy
implements IClassTransformer,
ILegacyClassTransformer {
    private static MixinTransformer transformer;
    private static List<Proxy> proxies;
    private boolean isActive = true;

    static {
        proxies = new ArrayList<Proxy>();
        transformer = new MixinTransformer();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public byte[] transformClassBytes(String name, String transformedName, byte[] basicClass) {
        if (this.isActive) {
            return transformer.transformClassBytes(name, transformedName, basicClass);
        }
        return basicClass;
    }

    public Proxy() {
        for (Proxy hook : proxies) {
            hook.isActive = false;
        }
        proxies.add(this);
        LogManager.getLogger((String)"mixin").debug("Adding new mixin transformer proxy #{}", new Object[]{proxies.size()});
    }

    @Override
    public boolean isDelegationExcluded() {
        return true;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (this.isActive) {
            return transformer.transformClassBytes(name, transformedName, basicClass);
        }
        return basicClass;
    }
}

