/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

public class ReEntranceLock {
    private boolean semaphore = false;
    private int depth = 0;
    private final int maxDepth;

    public boolean check() {
        return this.depth > this.maxDepth;
    }

    public boolean isSet() {
        return this.semaphore;
    }

    public ReEntranceLock set() {
        this.semaphore = true;
        return this;
    }

    public ReEntranceLock clear() {
        this.semaphore = false;
        return this;
    }

    public ReEntranceLock pop() {
        if (this.depth == 0) {
            throw new IllegalStateException("ReEntranceLock pop() with zero depth");
        }
        --this.depth;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean checkAndSet() {
        return this.semaphore |= this.check();
    }

    public ReEntranceLock(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public ReEntranceLock push() {
        ++this.depth;
        this.checkAndSet();
        return this;
    }
}

