/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;

public class SubstituteLoggerFactory
implements ILoggerFactory {
    volatile boolean postInitialization = false;
    final LinkedBlockingQueue<SubstituteLoggingEvent> eventQueue;
    final Map<String, SubstituteLogger> loggers = new ConcurrentHashMap<String, SubstituteLogger>();

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public void postInitialization() {
        this.postInitialization = true;
    }

    public SubstituteLoggerFactory() {
        this.eventQueue = new LinkedBlockingQueue();
    }

    public LinkedBlockingQueue<SubstituteLoggingEvent> getEventQueue() {
        return this.eventQueue;
    }

    public void clear() {
        this.loggers.clear();
        this.eventQueue.clear();
    }

    public List<SubstituteLogger> getLoggers() {
        return new ArrayList<SubstituteLogger>(this.loggers.values());
    }

    @Override
    public synchronized Logger getLogger(String name) {
        SubstituteLogger logger = this.loggers.get(name);
        if (logger == null) {
            logger = new SubstituteLogger(name, this.eventQueue, this.postInitialization);
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

