/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationType;

public class ObfuscationData<T>
implements Iterable<ObfuscationType> {
    private final T defaultValue;
    private final Map<ObfuscationType, T> data = new HashMap<ObfuscationType, T>();

    public String toString() {
        return String.format("ObfuscationData[%s,DEFAULT=%s]", this.listValues(), this.defaultValue);
    }

    public ObfuscationData(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T get(ObfuscationType type) {
        T value = this.data.get(type);
        return value != null ? value : this.defaultValue;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String values() {
        return "[" + this.listValues() + "]";
    }

    @Deprecated
    public void add(ObfuscationType type, T value) {
        this.put(type, value);
    }

    public ObfuscationData() {
        this(null);
    }

    @Override
    public Iterator<ObfuscationType> iterator() {
        return this.data.keySet().iterator();
    }

    private String listValues() {
        StringBuilder sb = new StringBuilder();
        boolean delim = false;
        for (ObfuscationType type : this.data.keySet()) {
            if (delim) {
                sb.append(',');
            }
            sb.append(type.getKey()).append('=').append(this.data.get(type));
            delim = true;
        }
        return sb.toString();
    }

    public void put(ObfuscationType type, T value) {
        this.data.put(type, value);
    }
}

