/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;

public class DefaultLoggingEvent
implements LoggingEvent {
    Logger logger;
    String callerBoundary;
    Throwable throwable;
    List<Object> arguments;
    Level level;
    List<Marker> markers;
    List<KeyValuePair> keyValuePairs;
    String threadName;
    long timeStamp;
    String message;

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public List<Marker> getMarkers() {
        return this.markers;
    }

    private List<Object> getNonNullArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Object>(3);
        }
        return this.arguments;
    }

    public void setThrowable(Throwable cause) {
        this.throwable = cause;
    }

    public void addArguments(Object ... args) {
        this.getNonNullArguments().addAll(Arrays.asList(args));
    }

    private List<KeyValuePair> getNonnullKeyValuePairs() {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new ArrayList<KeyValuePair>(4);
        }
        return this.keyValuePairs;
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setCallerBoundary(String fqcn) {
        this.callerBoundary = fqcn;
    }

    @Override
    public String getCallerBoundary() {
        return this.callerBoundary;
    }

    public void addMarker(Marker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList<Marker>(2);
        }
        this.markers.add(marker);
    }

    @Override
    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void addKeyValue(String key, Object value) {
        this.getNonnullKeyValuePairs().add(new KeyValuePair(key, value));
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public DefaultLoggingEvent(Level level, Logger logger) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Object[] getArgumentArray() {
        if (this.arguments == null) {
            return null;
        }
        return this.arguments.toArray();
    }

    public void addArgument(Object p) {
        this.getNonNullArguments().add(p);
    }
}

